/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.joint;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.joint.base.AbstractServoMotorBE;
import net.shao.valkyrien_space_war.block.joint.base.CommandConstraintComponent;
import net.shao.valkyrien_space_war.function.vs.VsConstraintUtil;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class UpdateAttachmentPacket {
    private final BlockPos pos;
    private final VsConstraintUtil.AttachmentConstraintRecord attachment;

    public UpdateAttachmentPacket(BlockPos pos, VsConstraintUtil.AttachmentConstraintRecord attachment) {
        this.pos = pos;
        this.attachment = attachment;
    }

    public UpdateAttachmentPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        long shipId0 = buffer.readLong();
        if (shipId0 == -2L) {
            this.attachment = null;
            return;
        }
        long shipId1 = buffer.readLong();
        double localPos0X = buffer.readDouble();
        double localPos0Y = buffer.readDouble();
        double localPos0Z = buffer.readDouble();
        double localPos1X = buffer.readDouble();
        double localPos1Y = buffer.readDouble();
        double localPos1Z = buffer.readDouble();
        double fixedDistance = buffer.readDouble();
        this.attachment = new VsConstraintUtil.AttachmentConstraintRecord(shipId0, shipId1, (Vector3dc)new Vector3d(localPos0X, localPos0Y, localPos0Z), (Vector3dc)new Vector3d(localPos1X, localPos1Y, localPos1Z), fixedDistance);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        if (this.attachment == null) {
            buffer.writeLong(-2L);
            return;
        }
        buffer.writeLong(this.attachment.shipId0());
        buffer.writeLong(this.attachment.shipId1());
        buffer.writeDouble(this.attachment.localPos0().x());
        buffer.writeDouble(this.attachment.localPos0().y());
        buffer.writeDouble(this.attachment.localPos0().z());
        buffer.writeDouble(this.attachment.localPos1().x());
        buffer.writeDouble(this.attachment.localPos1().y());
        buffer.writeDouble(this.attachment.localPos1().z());
        buffer.writeDouble(this.attachment.fixedDistance());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (blockEntity instanceof AbstractServoMotorBE) {
            AbstractServoMotorBE motor = (AbstractServoMotorBE)blockEntity;
            CommandConstraintComponent component = motor.getCommandConstraintComponent();
            component.setAttachment(this.attachment);
        }
        context.setPacketHandled(true);
    }
}

