/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.joint;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.joint.base.AbstractServoMotorBE;
import net.shao.valkyrien_space_war.block.joint.base.client.ServoMotorScreen;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommand;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommandType;
import net.shao.valkyrien_space_war.block.joint.command.SeparateMotorCommand;

public class UpdateSeparatePacket {
    private final BlockPos pos;
    private final List<SeparateMotorCommand> separates;

    public UpdateSeparatePacket(BlockPos pos, List<SeparateMotorCommand> separates) {
        this.pos = pos;
        this.separates = separates;
    }

    public UpdateSeparatePacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        int size = buffer.readInt();
        ArrayList<SeparateMotorCommand> separates = new ArrayList<SeparateMotorCommand>(size);
        for (int i = 0; i < size; ++i) {
            String rsChannelName = buffer.m_130277_();
            MotorCommand[] cmds = new MotorCommand[4];
            for (int j = 0; j < 4; ++j) {
                String s = buffer.m_130277_();
                if (s.equals("null")) {
                    cmds[j] = null;
                    continue;
                }
                MotorCommandType type = MotorCommandType.valueOf(s);
                float param1 = buffer.readFloat();
                float param2 = buffer.readFloat();
                MotorCommand cmd = new MotorCommand(type);
                cmd.setParam1(param1);
                cmd.setParam2(param2);
                cmds[j] = cmd;
            }
            separates.add(new SeparateMotorCommand(rsChannelName, cmds));
        }
        this.separates = separates;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.separates.size());
        for (SeparateMotorCommand sprt : this.separates) {
            buffer.m_130070_(sprt.getRsChannelName());
            MotorCommand[] cmd = sprt.getCommands();
            for (int i = 0; i < 4; ++i) {
                if (cmd[i] == null) {
                    buffer.m_130070_("null");
                    continue;
                }
                buffer.m_130070_(cmd[i].getType().name());
                buffer.writeFloat(cmd[i].getParam1());
                buffer.writeFloat(cmd[i].getParam2());
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            context.enqueueWork(() -> {
                BlockEntity patt3558$temp;
                ServerPlayer player = context.getSender();
                if (player != null && (patt3558$temp = player.m_9236_().m_7702_(this.pos)) instanceof AbstractServoMotorBE) {
                    AbstractServoMotorBE motor = (AbstractServoMotorBE)patt3558$temp;
                    motor.setSeparateControl(this.separates);
                    motor.m_6596_();
                }
            });
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (blockEntity instanceof AbstractServoMotorBE) {
                AbstractServoMotorBE motor = (AbstractServoMotorBE)blockEntity;
                motor.receiveSeparateControlPacket(this.separates);
                motor.m_6596_();
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof ServoMotorScreen) {
                    ServoMotorScreen screen2 = (ServoMotorScreen)screen;
                    screen2.updateCommandRows();
                }
            }
        }
        context.setPacketHandled(true);
    }
}

