/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.joint;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.joint.base.AbstractServoMotorBE;
import net.shao.valkyrien_space_war.block.joint.base.client.ServoMotorScreen;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommand;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommandType;

public class UpdateSeqCommandsPacket {
    private final BlockPos pos;
    private final List<MotorCommand[]> commands;

    public UpdateSeqCommandsPacket(BlockPos pos, List<MotorCommand[]> commands) {
        this.pos = pos;
        this.commands = commands;
    }

    public UpdateSeqCommandsPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        int size = buffer.readInt();
        ArrayList<MotorCommand[]> commands = new ArrayList<MotorCommand[]>(size);
        for (int i = 0; i < size; ++i) {
            MotorCommand[] cmds = new MotorCommand[4];
            for (int j = 0; j < 4; ++j) {
                String s = buffer.m_130277_();
                if (s.equals("null")) {
                    cmds[j] = null;
                    continue;
                }
                MotorCommandType type = MotorCommandType.valueOf(s);
                float param1 = buffer.readFloat();
                float param2 = buffer.readFloat();
                MotorCommand cmd = new MotorCommand(type);
                cmd.setParam1(param1);
                cmd.setParam2(param2);
                cmds[j] = cmd;
            }
            commands.add(cmds);
        }
        this.commands = commands;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.commands.size());
        for (MotorCommand[] cmd : this.commands) {
            for (int i = 0; i < 4; ++i) {
                if (cmd[i] == null) {
                    buffer.m_130070_("null");
                    continue;
                }
                buffer.m_130070_(cmd[i].getType().name());
                buffer.writeFloat(cmd[i].getParam1());
                buffer.writeFloat(cmd[i].getParam2());
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            context.enqueueWork(() -> {
                BlockEntity patt3188$temp;
                ServerPlayer player = context.getSender();
                if (player != null && (patt3188$temp = player.m_9236_().m_7702_(this.pos)) instanceof AbstractServoMotorBE) {
                    AbstractServoMotorBE motor = (AbstractServoMotorBE)patt3188$temp;
                    motor.setAndFilterCommandSequence(this.commands);
                    motor.m_6596_();
                }
            });
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            if (Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (blockEntity instanceof AbstractServoMotorBE) {
                AbstractServoMotorBE motor = (AbstractServoMotorBE)blockEntity;
                motor.receiveSeqUpdatePacket(this.commands);
                motor.m_6596_();
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof ServoMotorScreen) {
                    ServoMotorScreen screen2 = (ServoMotorScreen)screen;
                    screen2.updateCommandRows();
                }
            }
        }
        context.setPacketHandled(true);
    }
}

