/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.monitor;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.monitors.base.IVsswMonitorProvider;

public class ModMonitorScrollPacket {
    private final BlockPos blockPos;
    private final float mouseX;
    private final float mouseY;
    private final byte delta;

    public ModMonitorScrollPacket(BlockPos blockPos, float clickX, float clickY, byte delta) {
        this.blockPos = blockPos;
        this.mouseX = clickX;
        this.mouseY = clickY;
        this.delta = delta;
    }

    public ModMonitorScrollPacket(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.mouseX = buf.readFloat();
        this.mouseY = buf.readFloat();
        this.delta = buf.readByte();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeFloat(this.mouseX);
        buf.writeFloat(this.mouseY);
        buf.writeByte((int)this.delta);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity = context.getSender().m_9236_().m_7702_(this.blockPos);
            if (blockEntity instanceof IVsswMonitorProvider) {
                IVsswMonitorProvider be = (IVsswMonitorProvider)blockEntity;
                be.getMonitorComponent().onMouseScroll(this.mouseX, this.mouseY, this.delta);
            }
        });
        context.setPacketHandled(true);
    }
}

