/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.monitor;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.monitors.base.IVsswMonitorProvider;

public class VsswMonitorClickPacket {
    private final BlockPos blockPos;
    private final float clickX;
    private final float clickY;
    private final boolean isOuter;

    public VsswMonitorClickPacket(BlockPos blockPos, float clickX, float clickY, boolean isOuter) {
        this.blockPos = blockPos;
        this.clickX = clickX;
        this.clickY = clickY;
        this.isOuter = isOuter;
    }

    public VsswMonitorClickPacket(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.clickX = buf.readFloat();
        this.clickY = buf.readFloat();
        this.isOuter = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeFloat(this.clickX);
        buf.writeFloat(this.clickY);
        buf.writeBoolean(this.isOuter);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            BlockEntity blockEntity = sender.m_9236_().m_7702_(this.blockPos);
            if (blockEntity instanceof IVsswMonitorProvider) {
                IVsswMonitorProvider be = (IVsswMonitorProvider)blockEntity;
                be.getMonitorComponent().onClick(sender, this.clickX, this.clickY, this.isOuter);
            }
        });
        context.setPacketHandled(true);
    }
}

