/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.projectile;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.projectile.EnergyProjectile;
import net.shao.valkyrien_space_war.projectile.Projectile30mmRenderer;
import net.shao.valkyrien_space_war.projectile.base.ClientProjectile;
import net.shao.valkyrien_space_war.projectile.base.ProjectileManager;
import org.joml.Vector3f;

public class SpawnProjectilePacket {
    private final int id;
    private final short type;
    private final Vector3f position;
    private final Vector3f velocity;
    private final int color;

    public SpawnProjectilePacket(int id, short type, Vector3f position, Vector3f velocity, int color) {
        this.id = id;
        this.type = type;
        this.position = position;
        this.velocity = velocity;
        this.color = color;
    }

    public SpawnProjectilePacket(FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.type = buf.readShort();
        this.position = buf.m_269394_();
        this.velocity = buf.m_269394_();
        this.color = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeShort((int)this.type);
        buf.m_269582_(this.position);
        buf.m_269582_(this.velocity);
        buf.writeInt(this.color);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ClientProjectile projectile;
            switch (this.type) {
                case 0: {
                    ClientProjectile clientProjectile = new EnergyProjectile.Renderer(this.id, this.position, this.velocity, this.color);
                    break;
                }
                case 1: {
                    ClientProjectile clientProjectile = new Projectile30mmRenderer(this.id, this.position, this.velocity, this.color);
                    break;
                }
                default: {
                    ClientProjectile clientProjectile = projectile = null;
                }
            }
            if (projectile == null) {
                return;
            }
            ProjectileManager.addClientProjectile(projectile);
        });
        context.setPacketHandled(true);
    }
}

