/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.rs_channel;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.function.rs_channel.IRsChannelProvider;

public class SyncRsProviderChannelToClientPacket {
    private final BlockPos pos;
    private final int length;
    private final String[] channelNames;

    public SyncRsProviderChannelToClientPacket(BlockPos pos, String[] channelNames) {
        this.pos = pos;
        this.length = channelNames.length;
        this.channelNames = channelNames;
    }

    public SyncRsProviderChannelToClientPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.length = buf.readInt();
        this.channelNames = new String[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.channelNames[i] = buf.m_130277_();
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.length);
        for (String channelName : this.channelNames) {
            if (channelName == null) {
                buf.m_130070_("");
                continue;
            }
            buf.m_130070_(channelName);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (blockEntity instanceof IRsChannelProvider) {
                IRsChannelProvider provider = (IRsChannelProvider)blockEntity;
                provider.setClientRsChannels(this.channelNames);
            }
        });
        context.setPacketHandled(true);
    }
}

