/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.shield;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.energy_shield.AbstractEnergyShieldBE;

public class PacketEnergyShieldData {
    private final BlockPos blockPos;
    private final float yaw;
    private final float pitch;
    private final int maxLifeTime;
    private final boolean isApproaching;

    public PacketEnergyShieldData(BlockPos blockPos, float yaw, float pitch, int maxLifeTime, boolean isApproaching) {
        this.blockPos = blockPos;
        this.yaw = yaw;
        this.pitch = pitch;
        this.maxLifeTime = maxLifeTime;
        this.isApproaching = isApproaching;
    }

    public PacketEnergyShieldData(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.yaw = buf.readFloat();
        this.pitch = buf.readFloat();
        this.maxLifeTime = buf.readInt();
        this.isApproaching = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeInt(this.maxLifeTime);
        buf.writeBoolean(this.isApproaching);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            AbstractEnergyShieldBE blockEntity = (AbstractEnergyShieldBE)Minecraft.m_91087_().f_91073_.m_7702_(this.blockPos);
            if (blockEntity != null) {
                blockEntity.addClientShield(this.yaw, this.pitch, this.maxLifeTime, this.isApproaching);
            }
        });
        context.setPacketHandled(true);
    }
}

