/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.shield;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketEnergyShieldHit {
    private final BlockPos blockPos;
    private final Vec3 intersection;
    private final Vec3 normal;
    private final boolean isApproaching;
    private float speed;

    public PacketEnergyShieldHit(BlockPos blockPos, Vec3 intersection, Vec3 normal, boolean isApproaching, float speed) {
        this.blockPos = blockPos;
        this.intersection = intersection;
        this.normal = normal;
        this.isApproaching = isApproaching;
        this.speed = speed;
    }

    public PacketEnergyShieldHit(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.intersection = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.normal = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.isApproaching = buf.readBoolean();
        this.speed = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeDouble(this.intersection.f_82479_);
        buf.writeDouble(this.intersection.f_82480_);
        buf.writeDouble(this.intersection.f_82481_);
        buf.writeDouble(this.normal.f_82479_);
        buf.writeDouble(this.normal.f_82480_);
        buf.writeDouble(this.normal.f_82481_);
        buf.writeBoolean(this.isApproaching);
        buf.writeFloat(this.speed);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> {
                Level level = player.m_9236_();
                if (this.isApproaching) {
                    float scale = this.speed * 0.04f;
                    scale = Math.max(Math.min(scale, 0.5f), 0.025f);
                    int count = (int)(scale * 200.0f);
                    for (int i = 0; i < count; ++i) {
                        double angle = Math.PI * 2 * (double)i / (double)count;
                        Vec3 tangent1 = this.getTangent(this.normal);
                        Vec3 tangent2 = this.normal.m_82537_(tangent1).m_82541_();
                        Vec3 particleVelocity = tangent1.m_82490_(Math.cos(angle)).m_82549_(tangent2.m_82490_(Math.sin(angle))).m_82541_().m_82490_((double)scale);
                        level.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, this.intersection.f_82479_, this.intersection.f_82480_, this.intersection.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
                        particleVelocity = particleVelocity.m_82490_(1.5);
                        level.m_6493_((ParticleOptions)ParticleTypes.f_175826_, true, this.intersection.f_82479_, this.intersection.f_82480_, this.intersection.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
                    }
                } else {
                    for (int i = 0; i < 8; ++i) {
                        double angle = Math.PI * 2 * (double)i / 8.0;
                        Vec3 tangent1 = this.getTangent(this.normal);
                        Vec3 tangent2 = this.normal.m_82537_(tangent1).m_82541_();
                        Vec3 particleVelocity = tangent1.m_82490_(Math.cos(angle)).m_82549_(tangent2.m_82490_(Math.sin(angle))).m_82541_().m_82490_(0.1);
                        level.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, this.intersection.f_82479_, this.intersection.f_82480_, this.intersection.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }

    private Vec3 getTangent(Vec3 normal) {
        if (Math.abs(normal.f_82479_) > 0.1) {
            return new Vec3(normal.f_82480_, -normal.f_82479_, 0.0).m_82541_();
        }
        if (Math.abs(normal.f_82480_) > 0.1) {
            return new Vec3(0.0, normal.f_82481_, -normal.f_82480_).m_82541_();
        }
        return new Vec3(normal.f_82481_, 0.0, -normal.f_82479_).m_82541_();
    }
}

