/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.thruster;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.thruster.base.AbstractThrusterBE;

public class ThrusterSetColorPacket {
    private final BlockPos pos;
    private final int startColor;
    private final int endColor;

    public ThrusterSetColorPacket(BlockPos blockPos, int startColor, int endColor) {
        this.pos = blockPos;
        this.startColor = startColor;
        this.endColor = endColor;
    }

    public ThrusterSetColorPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.startColor = buffer.readInt();
        this.endColor = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.startColor);
        buf.writeInt(this.endColor);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            BlockEntity blockEntity = sender.m_9236_().m_7702_(this.pos);
            if (blockEntity instanceof AbstractThrusterBE) {
                AbstractThrusterBE be = (AbstractThrusterBE)blockEntity;
                be.setColors(this.startColor, this.endColor);
            }
        });
        context.setPacketHandled(true);
    }
}

