/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.thruster;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.thruster.base.AbstractThrusterBE;

public class ThrusterSetDirPacket {
    private final BlockPos pos;
    private final float yaw;
    private final float pitch;

    public ThrusterSetDirPacket(BlockPos pos, float yaw, float pitch) {
        this.pos = pos;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public ThrusterSetDirPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.yaw = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            BlockEntity blockEntity = sender.m_9236_().m_7702_(this.pos);
            if (blockEntity instanceof AbstractThrusterBE) {
                AbstractThrusterBE be = (AbstractThrusterBE)blockEntity;
                be.setEulerAngles(this.yaw, this.pitch);
            }
        });
        context.setPacketHandled(true);
    }
}

