/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.turret;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurretBE;
import net.shao.valkyrien_space_war.block.turret.base.TurretCameraEntity;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.turret.ResetCameraZoomPacket;

public class ActivateTurretPacket {
    private final BlockPos pos;
    private final int id;
    private final byte code;

    public ActivateTurretPacket(BlockPos bePos, int id, byte code) {
        this.pos = bePos;
        this.id = id;
        this.code = code;
    }

    public ActivateTurretPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.id = buf.m_130242_();
        this.code = buf.readByte();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130130_(this.id);
        buf.writeByte((int)this.code);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            switch (this.code) {
                case 1: {
                    BlockEntity blockEntity = sender.m_9236_().m_7702_(this.pos);
                    if (!(blockEntity instanceof AbstractTurretBE)) break;
                    AbstractTurretBE be = (AbstractTurretBE)blockEntity;
                    be.activate(sender);
                    break;
                }
                case 0: {
                    Entity entity = sender.m_9236_().m_6815_(this.id);
                    if (entity instanceof TurretCameraEntity) {
                        TurretCameraEntity camera = (TurretCameraEntity)entity;
                        camera.remove();
                    }
                    sender.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)sender));
                    ModNetworkHandler.sendToPlayer(sender, new ResetCameraZoomPacket());
                }
            }
        });
        context.setPacketHandled(true);
    }
}

