/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.turret;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.turret.energy.BasicEnergyTurretBE;

public class SyncEnergyTurretDataPacket {
    private final BlockPos blockPos;
    private final byte fireRate;
    private final byte gunLevel;
    private final float gunCompressionRatio;
    private final int color;

    public SyncEnergyTurretDataPacket(BlockPos blockPos, byte fireRate, byte gunLevel, float gunCompressionRatio, int color) {
        this.blockPos = blockPos;
        this.fireRate = fireRate;
        this.gunLevel = gunLevel;
        this.gunCompressionRatio = gunCompressionRatio;
        this.color = color;
    }

    public SyncEnergyTurretDataPacket(BlockPos blockPos, int fireRate, int gunLevel, float gunCompressionRatio, int color) {
        this(blockPos, (byte)fireRate, (byte)gunLevel, gunCompressionRatio, color);
    }

    public SyncEnergyTurretDataPacket(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.fireRate = buf.readByte();
        this.gunLevel = buf.readByte();
        this.gunCompressionRatio = buf.readFloat();
        this.color = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeByte((int)this.fireRate);
        buf.writeByte((int)this.gunLevel);
        buf.writeFloat(this.gunCompressionRatio);
        buf.writeInt(this.color);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            BlockEntity blockEntity = sender.m_9236_().m_7702_(this.blockPos);
            if (blockEntity instanceof BasicEnergyTurretBE) {
                BasicEnergyTurretBE be = (BasicEnergyTurretBE)blockEntity;
                if (this.fireRate != -1) {
                    be.setFireRate(this.fireRate);
                }
                if (this.gunLevel != -1) {
                    be.setGunLevel(this.gunLevel);
                }
                if (this.gunCompressionRatio != -1.0f) {
                    be.setCompressionRatio(this.gunCompressionRatio);
                }
                be.setProjectileColor(this.color);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

