/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.turret;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurretBE;

public class TurretAngleLimitPacket {
    private final BlockPos blockPos;
    private final float minYaw;
    private final float maxYaw;
    private final float minPitch;
    private final float maxPitch;

    public TurretAngleLimitPacket(BlockPos blockPos, float minYaw, float maxYaw, float minPitch, float maxPitch) {
        this.blockPos = blockPos;
        this.minYaw = minYaw;
        this.maxYaw = maxYaw;
        this.minPitch = minPitch;
        this.maxPitch = maxPitch;
    }

    public TurretAngleLimitPacket(FriendlyByteBuf buffer) {
        this.blockPos = buffer.m_130135_();
        this.minYaw = buffer.readFloat();
        this.maxYaw = buffer.readFloat();
        this.minPitch = buffer.readFloat();
        this.maxPitch = buffer.readFloat();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
        buffer.writeFloat(this.minYaw);
        buffer.writeFloat(this.maxYaw);
        buffer.writeFloat(this.minPitch);
        buffer.writeFloat(this.maxPitch);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            BlockEntity blockEntity = sender.m_9236_().m_7702_(this.blockPos);
            if (blockEntity instanceof AbstractTurretBE) {
                AbstractTurretBE be = (AbstractTurretBE)blockEntity;
                be.setAngleLimit(this.minYaw, this.maxYaw, this.minPitch, this.maxPitch);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

