/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.particle.explotion;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import net.shao.valkyrien_space_war.particle.ModParticles;

public class DebrisOptions
implements ParticleOptions {
    public static final Codec<DebrisOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("blockPos").forGetter(DebrisOptions::getBlockPos), (App)Codec.FLOAT.fieldOf("scale").forGetter(DebrisOptions::getScale)).apply((Applicative)instance, DebrisOptions::new));
    public static final ParticleOptions.Deserializer<DebrisOptions> DESERIALIZER = new ParticleOptions.Deserializer<DebrisOptions>(){

        public DebrisOptions fromNetwork(ParticleType<DebrisOptions> type, FriendlyByteBuf buf) {
            return new DebrisOptions(buf.readLong(), buf.readFloat());
        }

        public DebrisOptions fromCommand(ParticleType<DebrisOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            long blockPos = reader.readLong();
            reader.expect(' ');
            float scale = reader.readFloat();
            return new DebrisOptions(blockPos, scale);
        }
    };
    private final long blockPos;
    private final float scale;

    public DebrisOptions(long blockPos, float scale) {
        this.blockPos = blockPos;
        this.scale = scale;
    }

    public long getBlockPos() {
        return this.blockPos;
    }

    public float getScale() {
        return this.scale;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticles.DEBRIS_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeLong(this.blockPos);
        buf.writeFloat(this.scale);
    }

    public String m_5942_() {
        return String.format("%s %d %f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.blockPos, Float.valueOf(this.scale));
    }
}

