/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.particle.explotion;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shao.valkyrien_space_war.particle.explotion.DebrisOptions;

public class DebrisParticle
extends TextureSheetParticle {
    private final TextureAtlasSprite sprite;
    private final float rotationSpeed;
    private final float uo;
    private final float vo;
    private static final double BOUNCE_DAMPING = 0.8;
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.m_144952_((double)100.0);

    public DebrisParticle(ClientLevel level, DebrisOptions options, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        BlockPos blockPos = new BlockPos((Vec3i)BlockPos.m_122022_((long)options.getBlockPos()));
        float scale = options.getScale();
        this.sprite = this.getBlockSprite(level.m_8055_(blockPos));
        this.f_107663_ = 0.075f + this.f_107223_.m_188501_() * 0.1f * scale;
        this.f_107225_ = 60 + this.f_107223_.m_188503_(40);
        this.f_107226_ = 1.0f;
        this.rotationSpeed = (this.f_107223_.m_188501_() - 0.5f) * 0.2f;
        this.uo = this.f_107223_.m_188501_() * 3.0f;
        this.vo = this.f_107223_.m_188501_() * 3.0f;
        this.f_107215_ = xd * (double)0.15f + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.f_107216_ = yd * (double)0.15f + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.f_107217_ = zd * (double)0.15f + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.m_108337_(this.sprite);
    }

    private TextureAtlasSprite getBlockSprite(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state);
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.rotationSpeed;
        if (this.f_107218_) {
            this.f_107215_ *= 0.7;
            this.f_107217_ *= 0.7;
            this.f_107216_ = 0.0;
        }
    }

    protected float m_5970_() {
        return this.sprite.m_118367_((double)((this.uo + 1.0f) / 4.0f * 16.0f));
    }

    protected float m_5952_() {
        return this.sprite.m_118367_((double)(this.uo / 4.0f * 16.0f));
    }

    protected float m_5951_() {
        return this.sprite.m_118393_((double)(this.vo / 4.0f * 16.0f));
    }

    protected float m_5950_() {
        return this.sprite.m_118393_((double)((this.vo + 1.0f) / 4.0f * 16.0f));
    }

    public void m_6257_(double pX, double pY, double pZ) {
        double originalX = pX;
        double originalY = pY;
        double originalZ = pZ;
        if (this.f_107219_ && (pX != 0.0 || pY != 0.0 || pZ != 0.0) && pX * pX + pY * pY + pZ * pZ < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 vec3 = Entity.m_198894_(null, (Vec3)new Vec3(pX, pY, pZ), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            if (vec3.f_82479_ != pX || vec3.f_82480_ != pY || vec3.f_82481_ != pZ) {
                Vec3 collisionNormal = new Vec3(vec3.f_82479_ - originalX, vec3.f_82480_ - originalY, vec3.f_82481_ - originalZ).m_82541_();
                Vec3 velocity = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_);
                double dot = velocity.m_82526_(collisionNormal);
                Vec3 reflected = velocity.m_82546_(collisionNormal.m_82490_(2.0 * dot));
                reflected = reflected.m_82490_(0.8);
                this.f_107215_ = reflected.f_82479_;
                this.f_107216_ = reflected.f_82480_;
                this.f_107217_ = reflected.f_82481_;
            }
            pX = vec3.f_82479_;
            pY = vec3.f_82480_;
            pZ = vec3.f_82481_;
        }
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(pX, pY, pZ));
            this.m_107275_();
        }
        this.f_107218_ = originalY != pY && originalY < 0.0;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<DebrisOptions> {
        private final SpriteSet sprites;

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(DebrisOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DebrisParticle(level, type, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

