/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.particle.explotion;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import net.shao.valkyrien_space_war.particle.ModParticles;
import org.joml.Vector3f;

public class HighExplosionOptions
implements ParticleOptions {
    public static final Codec<HighExplosionOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("scale").forGetter(HighExplosionOptions::getScale), (App)Codec.FLOAT.fieldOf("expansionSpeed").forGetter(HighExplosionOptions::getExpansionSpeed), (App)Codec.FLOAT.fieldOf("dx").forGetter(HighExplosionOptions::getDirX), (App)Codec.FLOAT.fieldOf("dy").forGetter(HighExplosionOptions::getDirY), (App)Codec.FLOAT.fieldOf("dz").forGetter(HighExplosionOptions::getDirZ), (App)Codec.INT.fieldOf("duration").forGetter(HighExplosionOptions::getDuration)).apply((Applicative)instance, HighExplosionOptions::new));
    public static final ParticleOptions.Deserializer<HighExplosionOptions> DESERIALIZER = new ParticleOptions.Deserializer<HighExplosionOptions>(){

        public HighExplosionOptions fromNetwork(ParticleType<HighExplosionOptions> type, FriendlyByteBuf buf) {
            return new HighExplosionOptions(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt());
        }

        public HighExplosionOptions fromCommand(ParticleType<HighExplosionOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            float expansion = reader.readFloat();
            reader.expect(' ');
            float dx = reader.readFloat();
            reader.expect(' ');
            float dy = reader.readFloat();
            reader.expect(' ');
            float dz = reader.readFloat();
            reader.expect(' ');
            int duration = reader.readInt();
            return new HighExplosionOptions(scale, expansion, dx, dy, dz, duration);
        }
    };
    private final float scale;
    private final float expansionSpeed;
    private final Vector3f dir;
    private final int duration;

    public HighExplosionOptions(float scale, float expansionSpeed, float dx, float dy, float dz, int duration) {
        this.scale = scale;
        this.expansionSpeed = expansionSpeed;
        this.dir = new Vector3f(dx, dy, dz);
        this.duration = duration;
    }

    public float getScale() {
        return this.scale;
    }

    public float getExpansionSpeed() {
        return this.expansionSpeed;
    }

    public float getDirX() {
        return this.dir.x();
    }

    public float getDirY() {
        return this.dir.y();
    }

    public float getDirZ() {
        return this.dir.z();
    }

    public int getDuration() {
        return this.duration;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticles.HIGH_EXPLOSION_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.scale);
        buf.writeFloat(this.expansionSpeed);
        buf.m_269582_(this.dir);
        buf.writeInt(this.duration);
    }

    public String m_5942_() {
        return String.format("%s %.2f %.2f %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.scale), Float.valueOf(this.expansionSpeed), this.duration);
    }
}

