/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.particle.explotion;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shao.valkyrien_space_war.particle.ModParticles;
import net.shao.valkyrien_space_war.particle.explotion.DebrisOptions;
import net.shao.valkyrien_space_war.particle.explotion.ExplosionSmokeOptions;
import net.shao.valkyrien_space_war.particle.explotion.HighExplosionOptions;
import net.shao.valkyrien_space_war.sound.ModSounds;
import net.shao.valkyrien_space_war.sound.SoundHelper;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HighExplosionParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float scale;
    private final float expansionSpeed;
    private final Vector3f dir;
    private Vector3f[] smokeDir;
    private int smokeCd = 0;

    public HighExplosionParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, HighExplosionOptions options, SpriteSet sprites) {
        super(level, x, y, z, xd, yd, zd);
        Vec3 subtract;
        double lenSq;
        this.sprites = sprites;
        this.scale = Math.max(options.getScale(), 0.5f);
        this.f_107663_ = options.getScale();
        this.f_107225_ = (int)(this.scale * 40.0f);
        this.expansionSpeed = options.getExpansionSpeed();
        this.dir = new Vector3f(options.getDirX(), options.getDirY(), options.getDirZ());
        this.m_108339_(sprites);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 0.9f;
        this.f_107229_ = 0.3f;
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        if (cameraEntity != null && (lenSq = (subtract = cameraEntity.m_20182_().m_82492_(x, y, z)).m_7096_() * subtract.m_7096_() + subtract.m_7098_() * subtract.m_7098_() + subtract.m_7094_() * subtract.m_7094_()) > 140000.0) {
            SoundHelper.playCustomSound(x, y, z, (SoundEvent)ModSounds.EXPLOSION_30MM_FAR.get(), SoundSource.BLOCKS, 128.0f, 2.0f, true);
            return;
        }
        SoundHelper.playCustomSound(x, y, z, (SoundEvent)ModSounds.EXPLOSION_30MM_HE.get(), SoundSource.BLOCKS, 24.0f, 1.0f, true);
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107230_ = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        float progress = (float)this.f_107224_ / (float)this.f_107225_;
        if (progress < 0.3f) {
            this.f_107227_ = 1.0f;
            this.f_107228_ = 0.7f - progress * 2.0f;
            this.f_107229_ = 0.1f;
        } else if (progress < 0.6f) {
            this.f_107227_ = 1.0f;
            this.f_107228_ = 0.2f;
            this.f_107229_ = 0.1f;
        } else {
            float smokeProgress = (progress - 0.6f) / 0.4f;
            this.f_107227_ = 0.8f - smokeProgress * 0.8f;
            this.f_107228_ = 0.1f;
            this.f_107229_ = 0.1f;
        }
        if (this.f_107224_ < this.f_107225_) {
            this.createSubParticles();
        }
        this.m_108339_(this.sprites);
    }

    private void createSubParticles() {
        float scaleFactor = this.scale;
        Vector3f normalizedDir = new Vector3f((Vector3fc)this.dir);
        normalizedDir.normalize();
        double offsetRange = (double)scaleFactor * 0.8;
        if (this.f_107224_ == 1) {
            if (this.scale > 5.0f) {
                this.shockWave();
            }
            int count = (int)(8.0f * scaleFactor);
            this.smokeDir = new Vector3f[count / 16];
            BlockPos blockPos = new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_);
            List<BlockPos> nearbyBlocks = this.getRandomNearbyBlocks((Level)this.f_107208_, blockPos, (int)this.scale / 2);
            for (int i = 0; i < count; ++i) {
                Vector3f baseVelocity = new Vector3f((Vector3fc)normalizedDir);
                float spreadAngle = 60.0f;
                Vector3f randomSpread = this.createConeSpread(normalizedDir, spreadAngle);
                double velocityScale = 1.5 * (double)scaleFactor;
                Vector3f finalVelocity = new Vector3f((Vector3fc)baseVelocity.mul(this.expansionSpeed));
                finalVelocity.add((Vector3fc)randomSpread.mul(0.6f));
                finalVelocity.mul((float)velocityScale);
                double px = this.f_107212_ + (this.f_107223_.m_188500_() - 0.5) * offsetRange;
                double py = this.f_107213_ + (this.f_107223_.m_188500_() - 0.5) * offsetRange;
                double pz = this.f_107214_ + (this.f_107223_.m_188500_() - 0.5) * offsetRange;
                if (i < this.smokeDir.length) {
                    this.smokeDir[i] = new Vector3f((Vector3fc)finalVelocity).normalize();
                }
                if (nearbyBlocks.isEmpty()) continue;
                blockPos = nearbyBlocks.get(this.f_107223_.m_188503_(nearbyBlocks.size()));
                this.f_107208_.m_6493_((ParticleOptions)new DebrisOptions(blockPos.m_121878_(), this.scale), true, px, py, pz, (double)finalVelocity.x(), (double)finalVelocity.y(), (double)finalVelocity.z());
            }
            int ring = 0;
            while ((double)ring < 3.0 + (double)this.scale * 0.15) {
                int i = 0;
                while ((double)i < (double)(8.0f * this.scale) * 0.2) {
                    Vector3f randomDir = this.randomSphereDirection();
                    double radius = (double)scaleFactor * ((double)ring * 0.8);
                    double speed = (0.5 + this.f_107223_.m_188500_()) * (double)scaleFactor * 0.5;
                    this.f_107208_.m_6493_((ParticleOptions)new ExplosionSmokeOptions(this.scale), true, this.f_107212_ + (double)randomDir.x() * radius * 0.05, this.f_107213_ + (double)randomDir.y() * radius * 0.05, this.f_107214_ + (double)randomDir.z() * radius * 0.05, (double)randomDir.x() * speed, (double)randomDir.y() * speed, (double)randomDir.z() * speed);
                    ++i;
                }
                ++ring;
            }
        }
        if ((float)this.f_107224_ < this.scale) {
            for (int i = 0; i < this.smokeDir.length; ++i) {
                double v = 0.5 + this.f_107223_.m_188500_();
                double px = this.f_107212_ + (double)(this.smokeDir[i].x() * this.scale) * 0.25 * (double)this.f_107224_ * v;
                double py = this.f_107213_ + (double)(this.smokeDir[i].y() * this.scale) * 0.25 * (double)this.f_107224_ * v;
                double pz = this.f_107214_ + (double)(this.smokeDir[i].z() * this.scale) * 0.25 * (double)this.f_107224_ * v;
                this.f_107208_.m_6493_((ParticleOptions)new ExplosionSmokeOptions(this.scale), true, px, py, pz, 0.0, 0.0, 0.0);
            }
        }
        if (this.smokeCd % 5 == 0) {
            float count = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
            for (int i = 0; i < (int)((double)(count * this.scale) * 0.5); ++i) {
                double px = this.f_107212_ + (this.f_107223_.m_188500_() - 0.5) * offsetRange;
                double py = this.f_107213_ + (this.f_107223_.m_188500_() - 0.5) * offsetRange;
                double pz = this.f_107214_ + (this.f_107223_.m_188500_() - 0.5) * offsetRange;
                this.f_107208_.m_6493_((ParticleOptions)ModParticles.SMOKE_RING_PARTICLE.get(), true, px, py, pz, 0.0, 0.0, 0.0);
            }
        }
        ++this.smokeCd;
    }

    private List<BlockPos> getRandomNearbyBlocks(Level level, BlockPos center, int radius) {
        ArrayList blocks = new ArrayList();
        BlockPos.m_121990_((BlockPos)center.m_7918_(-radius, -radius, -radius), (BlockPos)center.m_7918_(radius, radius, radius)).filter(pos -> {
            BlockState state = level.m_8055_(pos);
            return !state.m_60795_() && state.m_60800_((BlockGetter)level, pos) < 1000.0f && state.m_60734_() != Blocks.f_50752_;
        }).forEach(pos -> blocks.add(pos.m_7949_()));
        int maxCount = radius * radius * radius;
        Collections.shuffle(blocks);
        return blocks.subList(0, Math.min(maxCount, blocks.size()));
    }

    private void shockWave() {
        float currentRadius = this.scale * 2.0f;
        int particleCount = Math.max(8, (int)(currentRadius * 20.0f));
        SimpleParticleType particle = ParticleTypes.f_123796_;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double dx = (double)currentRadius * Math.cos(angle);
            double dz = (double)currentRadius * Math.sin(angle);
            double jitter = (double)currentRadius * 0.1;
            double px = this.f_107212_ + dx + (this.f_107223_.m_188500_() - 0.5) * jitter;
            double pz = this.f_107214_ + dz + (this.f_107223_.m_188500_() - 0.5) * jitter;
            double py = this.f_107213_ + (this.f_107223_.m_188500_() - 0.5) * 0.5;
            this.f_107208_.m_6493_((ParticleOptions)particle, true, px, py, pz, dx, 0.0, dz);
        }
    }

    private Vector3f createConeSpread(Vector3f mainDir, float maxAngle) {
        Vector3f normalizedDir = new Vector3f((Vector3fc)mainDir).normalize();
        float angle = (this.f_107223_.m_188501_() * 2.0f - 1.0f) * maxAngle;
        angle = (float)Math.toRadians(angle);
        float randomRot = this.f_107223_.m_188501_() * ((float)Math.PI * 2);
        Vector3f perp1 = this.getPerpendicular(normalizedDir);
        Vector3f perp2 = new Vector3f((Vector3fc)normalizedDir).cross((Vector3fc)perp1).normalize();
        float x = (float)(Math.sin(angle) * Math.cos(randomRot));
        float y = (float)(Math.sin(angle) * Math.sin(randomRot));
        float z = (float)Math.cos(angle);
        Matrix3f transform = new Matrix3f();
        transform.setColumn(0, (Vector3fc)perp1);
        transform.setColumn(1, (Vector3fc)perp2);
        transform.setColumn(2, (Vector3fc)normalizedDir);
        Vector3f result = new Vector3f(x, y, z);
        transform.transform(result);
        return result.normalize();
    }

    private Vector3f getPerpendicular(Vector3f dir) {
        Vector3f perp = new Vector3f(-dir.z, 0.0f, dir.x);
        if ((double)perp.lengthSquared() < 1.0E-7) {
            perp.set(0.0f, dir.z, -dir.y);
        }
        return perp.normalize();
    }

    private Vector3f randomSphereDirection() {
        double theta = this.f_107223_.m_188500_() * Math.PI * 2.0;
        double phi = Math.acos(2.0 * this.f_107223_.m_188500_() - 1.0);
        return new Vector3f((float)(Math.sin(phi) * Math.cos(theta)), (float)(Math.sin(phi) * Math.sin(theta)), (float)Math.cos(phi));
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<HighExplosionOptions> {
        private final SpriteSet sprites;

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(HighExplosionOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new HighExplosionParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprites);
        }
    }
}

