/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.particle.explotion;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shao.valkyrien_space_war.particle.explotion.MuzzleFlashSmokeOptions;

public class MuzzleFlashSmokeParticle
extends TextureSheetParticle {
    public static final int TOTAL_FRAMES = 12;
    private static final float FRAME_TIME = 1.0f;
    private final SpriteSet sprites;
    private float scale;
    private final int animationDuration = 12;

    public MuzzleFlashSmokeParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd, MuzzleFlashSmokeOptions options, SpriteSet spriteSet) {
        super(world, x, y, z, xd, yd, zd);
        this.sprites = spriteSet;
        this.scale = options.getScale();
        this.f_107225_ = 40 + (int)(this.scale * 10.0f);
        if (this.scale < 0.5f) {
            this.m_6569_(this.scale * 10.0f);
        } else {
            this.m_6569_(this.scale * 0.5f + 3.0f);
        }
        this.f_107215_ = xd * 0.5 + (Math.random() * 2.0 - 1.0) * 0.25;
        this.f_107216_ = yd * 0.5 + (Math.random() * 2.0 - 1.0) * 0.25;
        this.f_107217_ = zd * 0.5 + (Math.random() * 2.0 - 1.0) * 0.25;
        this.m_108339_(spriteSet);
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107215_ *= (double)0.7f;
        this.f_107216_ *= (double)0.7f;
        this.f_107217_ *= (double)0.7f;
        this.f_107216_ += (double)0.01f;
        this.f_107215_ += (double)0.01f;
        if (!this.f_107220_) {
            if (this.f_107224_ <= 12) {
                this.setSpriteFromAge2(this.sprites);
                this.f_107663_ *= 1.1f;
            } else {
                float lifeProgress = (float)this.f_107224_ / (float)this.f_107225_;
                this.f_107230_ = (1.0f - lifeProgress) * 0.75f;
                this.m_108337_(this.sprites.m_5819_(this.animationDuration, this.animationDuration));
                this.f_107663_ *= 1.001f;
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void setSpriteFromAge2(SpriteSet pSprite) {
        if (!this.f_107220_) {
            this.m_108337_(pSprite.m_5819_(this.f_107224_, this.animationDuration));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<MuzzleFlashSmokeOptions> {
        private final SpriteSet sprites;

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(MuzzleFlashSmokeOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new MuzzleFlashSmokeParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprites);
        }
    }
}

