/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.particle.explotion;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShockwaveParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float baseScale;
    private final float expansionRate;
    private float prevScale;
    private float targetScale;

    public ShockwaveParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, SpriteSet sprites) {
        super(level, x, y, z, xd, yd, zd);
        this.sprites = sprites;
        this.baseScale = 1.0f;
        this.expansionRate = 1.5f;
        this.f_107225_ = 15;
        this.f_107663_ = this.baseScale;
        this.m_108339_(sprites);
        this.f_107226_ = 0.0f;
        this.f_107219_ = false;
        this.f_172258_ = 0.98f;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107230_ = 0.5f;
        this.f_107215_ += (this.f_107223_.m_188500_() - 0.5) * 0.2;
        this.f_107216_ += (this.f_107223_.m_188500_() - 0.5) * 0.1;
        this.f_107217_ += (this.f_107223_.m_188500_() - 0.5) * 0.2;
        this.prevScale = this.baseScale;
        this.targetScale = this.baseScale;
    }

    public void m_5989_() {
        super.m_5989_();
        this.prevScale = this.f_107663_;
        this.targetScale *= this.expansionRate;
        this.f_107663_ = this.targetScale;
        this.f_107230_ = 0.5f * (1.0f - (float)this.f_107224_ / (float)this.f_107225_);
        this.m_108339_(this.sprites);
        if ((float)this.f_107224_ > (float)this.f_107225_ * 0.7f) {
            this.f_107215_ += (this.f_107223_.m_188500_() - 0.5) * 0.02;
            this.f_107217_ += (this.f_107223_.m_188500_() - 0.5) * 0.02;
        }
    }

    private float getInterpolatedScale(float partialTicks) {
        float progress = Mth.m_14036_((float)(((float)this.f_107224_ + partialTicks) / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        float easeProgress = Mth.m_14031_((float)(progress * (float)Math.PI / 2.0f));
        return Mth.m_14179_((float)easeProgress, (float)this.prevScale, (float)this.targetScale);
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float currentScale = this.getInterpolatedScale(partialTicks);
        float originalSize = this.f_107663_;
        this.f_107663_ = currentScale;
        super.m_5744_(buffer, renderInfo, partialTicks);
        this.f_107663_ = originalSize;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    protected int m_6355_(float partialTick) {
        int skylight = 15;
        int blocklight = 15;
        return skylight << 20 | blocklight << 4;
    }

    public void m_6257_(double dx, double dy, double dz) {
        this.m_107259_(this.m_107277_().m_82386_(dx, dy, dz));
        this.m_107275_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ShockwaveParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

