/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.projectile;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.function.ExplosionHelper;
import net.shao.valkyrien_space_war.projectile.base.ProjectileProperties;
import net.shao.valkyrien_space_war.projectile.base.VSSWProjectile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Projectile30mm {

    public static class HEI
    extends Base {
        public HEI(@NotNull ProjectileProperties properties, @Nullable Entity owner, Level level, boolean isVsPhyTick, Vec3 direction, Vec3 position) {
            super(properties, owner, level, isVsPhyTick, direction, position);
        }

        @Override
        protected void onHitBlock(BlockHitResult result) {
            super.onHitBlock(result);
            this.explode(result.m_82425_().m_252807_(), true);
        }

        @Override
        protected void onHitEntity(EntityHitResult hitResult) {
            super.onHitEntity(hitResult);
            this.explode(hitResult.m_82443_().m_20182_(), true);
        }
    }

    public static class HEDP
    extends Base {
        private boolean needsToExplode = false;
        private int delay = 0;

        public HEDP(@NotNull ProjectileProperties properties, @Nullable Entity owner, Level level, boolean isVsPhyTick, Vec3 direction, Vec3 position) {
            super(properties, owner, level, isVsPhyTick, direction, position);
        }

        @Override
        public void tick() {
            super.tick();
            if (this.needsToExplode) {
                ++this.delay;
                if (this.delay > 1) {
                    this.needsToExplode = false;
                    this.explode(this.position.m_7096_(), this.position.m_7098_(), this.position.m_7094_(), false);
                }
            }
        }

        @Override
        protected void onHitBlock(BlockHitResult result) {
            super.onHitBlock(result);
            if (this.delay == 0 && !this.needsToExplode) {
                this.needsToExplode = true;
            }
        }

        @Override
        public void removeImmediately() {
            super.removeImmediately();
            if (this.needsToExplode) {
                this.needsToExplode = false;
                this.explodeWithOutRemover(this.position.m_7096_(), this.position.m_7098_(), this.position.m_7094_(), false);
            }
        }
    }

    public static class HE
    extends Base {
        public HE(@NotNull ProjectileProperties properties, @Nullable Entity owner, Level level, boolean isVsPhyTick, Vec3 direction, Vec3 position) {
            super(properties, owner, level, isVsPhyTick, direction, position);
        }

        @Override
        protected void onHitBlock(BlockHitResult result) {
            super.onHitBlock(result);
            this.explode(result.m_82425_().m_252807_(), false);
        }

        @Override
        protected void onHitEntity(EntityHitResult hitResult) {
            super.onHitEntity(hitResult);
            this.explode(hitResult.m_82443_().m_20182_(), false);
        }
    }

    public static class AP
    extends Base {
        public AP(@NotNull ProjectileProperties properties, @Nullable Entity owner, Level level, boolean isVsPhyTick, Vec3 direction, Vec3 position) {
            super(properties, owner, level, isVsPhyTick, direction, position);
        }
    }

    private static abstract class Base
    extends VSSWProjectile {
        public Base(@NotNull ProjectileProperties properties, @Nullable Entity owner, Level level, boolean isVsPhyTick, Vec3 direction, Vec3 position) {
            super(properties, owner, level, isVsPhyTick, direction, position);
        }

        @Override
        public short getClientRendererType() {
            return 1;
        }

        protected void explode(Vec3 pos, boolean fire) {
            this.explode(pos.f_82479_, pos.f_82480_, pos.f_82481_, fire);
        }

        protected void explode(double x, double y, double z, boolean fire) {
            ExplosionHelper.createHighExplosion(this.level, this.owner, this.velocity.m_252839_(), x, y, z, 1.5f, fire);
            this.removeImmediately();
        }

        protected void explodeWithOutRemover(double x, double y, double z, boolean fire) {
            ExplosionHelper.createHighExplosion(this.level, this.owner, this.velocity.m_252839_(), x, y, z, 1.5f, fire);
        }
    }
}

