/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.projectile.base;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.projectile.base.ProjectileManager;
import net.shao.valkyrien_space_war.sound.MovingSoundInstance;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class ClientProjectile {
    protected final int id;
    protected Vector3f position;
    protected int color;
    protected Vector3f oldPosition;
    protected Vector3f oOldPosition;
    private long beat;
    private MovingSoundInstance sound;

    public ClientProjectile(int id, Vector3f position, Vector3f velocity, int color) {
        this.id = id;
        this.position = new Vector3f((Vector3fc)position).add((Vector3fc)velocity.mul(0.5f));
        this.color = color;
        this.oldPosition = new Vector3f((Vector3fc)position);
        this.oOldPosition = new Vector3f((Vector3fc)position);
        this.beat = System.currentTimeMillis();
        this.sound = this.newSound();
        if (this.sound != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.sound);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setPosition(Vector3f newPos) {
        this.oOldPosition = this.oldPosition;
        this.oldPosition = this.position;
        this.position = newPos;
        this.beat = System.currentTimeMillis();
    }

    @Nullable
    private MovingSoundInstance newSound() {
        return null;
    }

    public void render(PoseStack poseStack, MultiBufferSource.BufferSource buffer, float partialTick) {
        if (System.currentTimeMillis() - this.beat > 10000L) {
            ProjectileManager.removeClientProjectile(this.id);
        }
        if (this.sound != null) {
            Vec3 renderPo = this.getRenderPos(0.0f)[0];
            this.sound.updatePosition(new Vec3(renderPo.m_7096_(), renderPo.m_7098_(), renderPo.m_7094_()));
        }
    }

    public void remove() {
        Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this.sound);
        this.sound = null;
    }

    public Vec3[] getRenderPos(float partialTicks) {
        float timeSinceLast = (float)(System.currentTimeMillis() - this.beat) / 1000.0f;
        float lerpFactor = Mth.m_14036_((float)(timeSinceLast * 20.0f), (float)0.0f, (float)1.0f);
        return new Vec3[]{new Vec3((double)Mth.m_14179_((float)lerpFactor, (float)this.oldPosition.x(), (float)this.position.x()), (double)Mth.m_14179_((float)lerpFactor, (float)this.oldPosition.y(), (float)this.position.y()), (double)Mth.m_14179_((float)lerpFactor, (float)this.oldPosition.z(), (float)this.position.z())), new Vec3((double)Mth.m_14179_((float)lerpFactor, (float)this.oOldPosition.x(), (float)this.oldPosition.x()), (double)Mth.m_14179_((float)lerpFactor, (float)this.oOldPosition.y(), (float)this.oldPosition.y()), (double)Mth.m_14179_((float)lerpFactor, (float)this.oOldPosition.z(), (float)this.oldPosition.z()))};
    }
}

