/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.projectile.base;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.energy_shield.AbstractEnergyShieldBE;
import net.shao.valkyrien_space_war.function.ModDamageTypes;
import net.shao.valkyrien_space_war.function.manager.ModResourceManager;
import net.shao.valkyrien_space_war.function.raycast.LongRangeRaycaster;
import net.shao.valkyrien_space_war.function.terrain.ChunkLoadManager;
import net.shao.valkyrien_space_war.function.util.ModMathUtil;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.projectile.RemoveProjectilePacket;
import net.shao.valkyrien_space_war.network.projectile.SpawnProjectilePacket;
import net.shao.valkyrien_space_war.network.projectile.SyncProjectilePacket;
import net.shao.valkyrien_space_war.projectile.base.ProjectileManager;
import net.shao.valkyrien_space_war.projectile.base.ProjectileProperties;
import net.shao.valkyrien_space_war.projectile.base.ProjectileUtil;
import net.shao.valkyrien_space_war.projectile.base.VSSWProjectileEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.valkyrienskies.core.impl.config.VSCoreConfig;

public abstract class VSSWProjectile {
    private static final Map<BlockPos, Float> blockDamageMap = new WeakHashMap<BlockPos, Float>();
    public final int MAX_LIFETIME;
    protected final Level level;
    protected boolean isVsPhyTick;
    protected final int physicsTicksPerGameTick;
    private int phyTickCount;
    protected final float muzzleVelocity;
    protected final float gravity;
    protected final float drag;
    protected float blockDamage;
    protected float entityDamage;
    protected Vec3 direction;
    protected Vec3 position;
    protected Vec3 velocity;
    protected Vec3 phyVelocity;
    protected final int id;
    protected int lifetime;
    private final int color;
    private boolean isAlive = true;
    protected Entity owner;

    public VSSWProjectile(@NotNull ProjectileProperties properties, @Nullable Entity owner, Level level, boolean isVsPhyTick, Vec3 direction, Vec3 position) {
        this.muzzleVelocity = properties.muzzleVelocity();
        this.blockDamage = Math.max(properties.blockDamage(), 0.01f);
        this.entityDamage = properties.entityDamage();
        this.MAX_LIFETIME = properties.maxLifeTime();
        this.color = properties.color();
        float[] gravDragByDimension = ProjectileUtil.getGravDragByDimension((ResourceKey<Level>)level.m_46472_());
        this.gravity = properties.gravity() * gravDragByDimension[0];
        float v = properties.drag() * gravDragByDimension[1];
        this.drag = v == 0.0f ? 1.0f : v;
        this.owner = owner;
        this.level = level;
        this.isVsPhyTick = isVsPhyTick;
        this.direction = direction;
        this.position = position;
        this.phyTickCount = this.physicsTicksPerGameTick = VSCoreConfig.SERVER.getPt().getPhysicsTicksPerGameTick();
        this.velocity = direction.m_82490_((double)this.muzzleVelocity);
        this.phyVelocity = new Vec3(this.velocity.f_82479_ / (double)this.physicsTicksPerGameTick, this.velocity.f_82480_ / (double)this.physicsTicksPerGameTick, this.velocity.f_82481_ / (double)this.physicsTicksPerGameTick);
        this.id = ProjectileManager.generateID();
        this.lifetime = 0;
    }

    public void spawn() {
        MinecraftForge.EVENT_BUS.post((Event)new VSSWProjectileEvent.OnSpawn(this));
        ModNetworkHandler.sendToAllPlayers(this.level, new SpawnProjectilePacket(this.id, this.getClientRendererType(), this.position.m_252839_(), this.velocity.m_252839_(), this.color));
        if (this.isVsPhyTick) {
            this.tick();
        }
    }

    public boolean isVsPhyTick() {
        return this.isVsPhyTick;
    }

    public Entity getOwner() {
        return this.owner;
    }

    public void setOwner(Entity owner) {
        this.owner = owner;
    }

    public abstract short getClientRendererType();

    public void tick() {
        ServerLevel serverLevel = (ServerLevel)this.level;
        if (this.position.f_82480_ < (double)this.level.m_141937_()) {
            this.remove();
            return;
        }
        Vec3 nextPos = this.position.m_82549_(this.velocity);
        if (!this.checkEnergyShield(this.position, nextPos)) {
            nextPos = this.checkProjectile(serverLevel);
            if (!this.isVsPhyTick) {
                this.position = new Vec3(nextPos.f_82479_, nextPos.f_82480_, nextPos.f_82481_);
                this.velocity = this.velocity.m_82490_((double)this.drag).m_82520_(0.0, (double)(-this.gravity), 0.0);
            }
        }
        BlockPos currentBP = new BlockPos((int)this.position.f_82479_, (int)this.position.f_82480_, (int)this.position.f_82481_);
        ModNetworkHandler.sendToNearbyPlayers(128, this.level, currentBP, new SyncProjectilePacket(this.id, this.position.m_252839_()));
        double lenSq = this.velocity.m_7096_() * this.velocity.m_7096_() + this.velocity.m_7098_() * this.velocity.m_7098_() + this.velocity.m_7094_() * this.velocity.m_7094_();
        if (this.lifetime++ > this.MAX_LIFETIME || this.blockDamage <= 0.0f || this.entityDamage <= 0.0f || lenSq < 0.001) {
            this.remove();
        }
    }

    public void vsPhyTick() {
        if (this.phyTickCount == this.physicsTicksPerGameTick) {
            this.velocity = this.velocity.m_82490_((double)this.drag).m_82520_(0.0, (double)(-this.gravity), 0.0);
            this.phyVelocity = new Vec3(this.velocity.f_82479_ / (double)this.physicsTicksPerGameTick, this.velocity.f_82480_ / (double)this.physicsTicksPerGameTick, this.velocity.f_82481_ / (double)this.physicsTicksPerGameTick);
            this.phyTickCount = 0;
        }
        this.position = this.position.m_82549_(this.phyVelocity);
        ++this.phyTickCount;
    }

    public Vec3 getDeltaMovement() {
        return new Vec3(this.velocity.m_7096_(), this.velocity.m_7098_(), this.velocity.m_7094_());
    }

    public void setDeltaMovement(Vec3 deltaMovement) {
        this.velocity = new Vec3(deltaMovement.m_7096_(), deltaMovement.m_7098_(), deltaMovement.m_7094_());
    }

    public void setPos(Vec3 pos) {
        this.position = new Vec3(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
    }

    public double getX() {
        return this.position.f_82479_;
    }

    public double getY() {
        return this.position.f_82480_;
    }

    public double getZ() {
        return this.position.f_82481_;
    }

    private Vec3 checkProjectile(ServerLevel serverLevel) {
        Vec3 nextPos = this.position.m_82549_(this.velocity);
        BlockPos currentBP = new BlockPos((int)this.position.f_82479_, (int)this.position.f_82480_, (int)this.position.f_82481_);
        BlockPos nextBP = new BlockPos((int)nextPos.f_82479_, (int)nextPos.f_82480_, (int)nextPos.f_82481_);
        ChunkSource chunkSource = this.level.m_7726_();
        EntityHitResult nearestEntityHit = this.findNearestEntityHit(this.level, this.position, nextPos);
        if (nearestEntityHit != null) {
            this.onHitEntity(nearestEntityHit);
        }
        if (!this.isAlive) {
            return nextPos;
        }
        BlockPos blockPos = LongRangeRaycaster.hasOcclusion(serverLevel, this.position, nextPos);
        if (chunkSource.m_5563_(nextBP.m_123341_() >> 4, nextBP.m_123343_() >> 4)) {
            BlockHitResult hitResult;
            if (blockPos != null && !chunkSource.m_5563_(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4)) {
                this.loadChunk(serverLevel, blockPos);
            }
            if ((hitResult = this.level.m_45547_(new ClipContext(this.position, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null))).m_6662_() == HitResult.Type.BLOCK) {
                this.onHitBlock(hitResult);
                nextPos = hitResult.m_82450_();
            }
        } else if (blockPos != null) {
            this.loadChunk(serverLevel, blockPos);
            BlockHitResult hitResult = this.level.m_45547_(new ClipContext(this.position, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                this.onHitBlock(hitResult);
                nextPos = hitResult.m_82450_();
            } else {
                this.onHitBlock(blockPos);
            }
        }
        return nextPos;
    }

    private boolean checkEnergyShield(Vec3 pos, Vec3 nextPos) {
        ArrayList<ShieldHitResult> hitPoints = new ArrayList<ShieldHitResult>();
        for (ModConnectorBE be : ModResourceManager.allConnectorBe) {
            float finalRange;
            AbstractEnergyShieldBE shield;
            Vec3 coordinate;
            int lineIntersectingSphere;
            if (be.getBeType() != ModConnectorBE.ConnectorType.ENERGY_SHIELD || (lineIntersectingSphere = ModMathUtil.checkLineSphereRelation(pos, nextPos, coordinate = (shield = (AbstractEnergyShieldBE)be).getShieldCenter(), finalRange = shield.getRange())) <= 0) continue;
            Vec3 intersection = ModMathUtil.intersectionCalculator(coordinate, finalRange, pos, this.velocity);
            boolean isApproaching = lineIntersectingSphere == 1;
            Vec3 reflectedVelocity = Vec3.f_82478_;
            if (isApproaching) {
                Vec3 normal = intersection.m_82546_(coordinate).m_82541_();
                reflectedVelocity = this.velocity.m_82546_(normal.m_82490_(2.0 * this.velocity.m_82526_(normal)));
            }
            hitPoints.add(new ShieldHitResult(shield, intersection, reflectedVelocity, isApproaching));
        }
        hitPoints.sort(Comparator.comparingDouble(entry -> entry.hitPos.m_82557_(this.position)));
        float speed = (float)this.velocity.m_82553_();
        ShieldHitResult firstReflectionPos = null;
        if (!hitPoints.isEmpty()) {
            ShieldHitResult shieldHitResult = (ShieldHitResult)hitPoints.get(0);
            if (shieldHitResult.isApproaching) {
                firstReflectionPos = shieldHitResult;
            } else {
                shieldHitResult.shieldBe.genShield(shieldHitResult.hitPos, speed, false);
            }
        }
        if (firstReflectionPos == null) {
            for (ShieldHitResult hitPoint : hitPoints) {
                if (!hitPoint.isApproaching) continue;
                firstReflectionPos = hitPoint;
                break;
            }
        }
        if (firstReflectionPos != null) {
            firstReflectionPos.shieldBe.genShield(firstReflectionPos.hitPos, speed, true);
            this.setPos(firstReflectionPos.hitPos);
            this.setDeltaMovement(firstReflectionPos.reflectedVelocity);
            this.onHitEnergyShield(firstReflectionPos.hitPos);
            return true;
        }
        return false;
    }

    protected void onHitEnergyShield(Vec3 hitPos) {
        this.isVsPhyTick = false;
    }

    private void loadChunk(ServerLevel serverLevel, BlockPos currentBP, BlockPos nextBP) {
        ChunkPos[] chunkPos = ChunkLoadManager.calculateChunkPath(currentBP.m_123341_(), currentBP.m_123343_(), nextBP.m_123341_(), nextBP.m_123343_());
        int count = 0;
        for (ChunkPos chunk : chunkPos) {
            ChunkLoadManager.getManagerForLevel(serverLevel).addOrUpdateChunkPos(chunk.f_45578_, chunk.f_45579_, 0);
            ++count;
        }
    }

    private void loadChunk(ServerLevel serverLevel, BlockPos pos) {
        ChunkLoadManager.getManagerForLevel(serverLevel).addOrUpdateChunkPos(pos.m_123341_() >> 4, pos.m_123343_() >> 4, 0);
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        if (this.entityDamage <= 0.0f) {
            return;
        }
        Entity target = hitResult.m_82443_();
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            Holder.Reference damageTypeHolder = this.level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.ENERGY_PROJECTILE);
            DamageSource damageSource = new DamageSource((Holder)damageTypeHolder, (Entity)livingTarget, this.owner);
            livingTarget.m_6469_(damageSource, this.entityDamage);
            livingTarget.f_19802_ = 0;
            this.entityDamage -= livingTarget.m_21223_();
            Vector3f knockbackDirection = new Vector3f((float)this.velocity.f_82479_, (float)this.velocity.f_82480_, (float)this.velocity.f_82481_).negate();
            livingTarget.m_147240_(this.velocity.m_82553_() / 60.0, (double)knockbackDirection.x, (double)knockbackDirection.z);
        }
    }

    private EntityHitResult findNearestEntityHit(Level level, Vec3 start, Vec3 end) {
        AABB detectionBox = new AABB(start, end).m_82400_(1.0);
        List entities = level.m_6249_((Entity)null, detectionBox, entity -> entity.m_6084_());
        Entity nearestEntity = null;
        double minDistance = Double.MAX_VALUE;
        for (Entity entity2 : entities) {
            double dist;
            AABB aabb = entity2.m_20191_().m_82400_(0.3);
            Optional hitPos = aabb.m_82371_(start, end);
            if (!hitPos.isPresent() || !((dist = start.m_82557_((Vec3)hitPos.get())) < minDistance)) continue;
            minDistance = dist;
            nearestEntity = entity2;
        }
        return nearestEntity != null ? new EntityHitResult(nearestEntity) : null;
    }

    protected void onHitBlock(BlockHitResult result) {
        this.onHitBlock(result.m_82425_());
    }

    protected void onHitBlock(BlockPos pos) {
        this.isVsPhyTick = false;
        if (this.blockDamage <= 0.0f) {
            return;
        }
        BlockState state = this.level.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)this.level, pos);
        float damageDelta = this.blockDamage / hardness;
        this.blockDamage -= hardness;
        this.blockDamage *= 0.75f;
        if (this.tryDamageBlock(pos, state, damageDelta)) {
            float min = Math.min(1.0f, hardness / this.blockDamage);
            float v = Math.max(Math.min(1.0f, 1.0f - min), 0.0f);
            if (v == 0.0f) {
                this.remove();
            }
            this.velocity = this.velocity.m_82490_((double)v);
        }
    }

    protected boolean tryDamageBlock(BlockPos pos, BlockState state, float damage) {
        float totalDamage = blockDamageMap.getOrDefault(pos, Float.valueOf(0.0f)).floatValue() + damage;
        blockDamageMap.put(pos, Float.valueOf(totalDamage));
        if (totalDamage >= 1.0f) {
            this.level.m_6801_(pos.hashCode(), pos, -1);
            this.level.m_46961_(pos, true);
            blockDamageMap.remove(pos);
            return true;
        }
        int progress = (int)(totalDamage * 10.0f);
        this.level.m_6801_(pos.hashCode(), pos, progress);
        this.level.m_5594_(null, pos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return false;
    }

    public void remove() {
        if (!this.isAlive) {
            MinecraftForge.EVENT_BUS.post((Event)new VSSWProjectileEvent.OnRemove(this));
            ModNetworkHandler.sendToAllPlayers(this.level, new RemoveProjectilePacket(this.id));
        }
        this.isAlive = false;
    }

    public void removeImmediately() {
        this.isAlive = false;
        this.remove();
    }

    public Level getLevel() {
        return this.level;
    }

    public int getID() {
        return this.id;
    }

    private record ShieldHitResult(AbstractEnergyShieldBE shieldBe, Vec3 hitPos, Vec3 reflectedVelocity, boolean isApproaching) {
    }
}

