/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.screen.configScreen;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.shao.valkyrien_space_war.screen.configScreen.ModDialogScreen;
import net.shao.valkyrien_space_war.screen.configScreen.ModFileListScrollPanel;

public class JsonFileSelectScreen
extends Screen {
    private final Path dir;
    private final Consumer<String> callback;
    private boolean isSaveMode;
    private ScrollPanel fileListPanel;
    private List<String> configFiles = new ArrayList<String>();
    private ArrayList<Button> fileButtons = new ArrayList();

    public JsonFileSelectScreen(Component title, Path dir, Consumer<String> callback, boolean isSaveMode) {
        super(title);
        this.dir = dir;
        this.callback = callback;
        this.isSaveMode = isSaveMode;
    }

    protected void m_7856_() {
        this.loadFileList();
        this.fileButtons.clear();
        for (String cf : this.configFiles) {
            Button fileButton = Button.m_253074_((Component)Component.m_237113_((String)cf), btn -> {
                if (this.isSaveMode) {
                    Minecraft.m_91087_().pushGuiLayer((Screen)new ModDialogScreen("gui.valkyrien_space_war.overwrite_file", todo -> {
                        if (todo.booleanValue()) {
                            this.returnCallback(cf);
                        }
                    }));
                } else {
                    this.returnCallback(cf);
                }
            }).m_253136_();
            this.fileButtons.add(fileButton);
        }
        this.fileListPanel = new ModFileListScrollPanel(this.f_96541_, this.f_96543_ - 100, this.f_96544_ - 55, 5, 50, this.dir, this.fileButtons);
        this.m_142416_((GuiEventListener)this.fileListPanel);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.valkyrien_space_war.back"), btn -> {
            Minecraft.m_91087_().popGuiLayer();
            this.m_7861_();
        }).m_252794_(10, 5).m_253046_(35, 15).m_253136_());
        if (this.isSaveMode) {
            EditBox inputBox = new EditBox(this.f_96547_, 70, this.f_96544_ - 50, this.f_96543_ - 200, 15, (Component)Component.m_237113_((String)""));
            Button saveButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.valkyrien_space_war.config_save"), btn -> this.returnCallback(this.checkInput(inputBox.m_94155_()))).m_252794_(this.f_96543_ - 125, this.f_96544_ - 50).m_253046_(60, 15).m_253136_();
            this.m_142416_((GuiEventListener)inputBox);
            this.m_142416_((GuiEventListener)saveButton);
        }
    }

    private Component checkButtonName(String name) {
        return Component.m_237113_((String)name.substring(0, name.lastIndexOf(46)));
    }

    private String checkInput(String val) {
        if (!((String)val).endsWith(".json")) {
            val = (String)val + ".json";
        }
        return val;
    }

    private void returnCallback(String result) {
        this.callback.accept(result);
        Minecraft.m_91087_().popGuiLayer();
        this.m_7861_();
    }

    private void loadFileList() {
        try {
            if (!Files.exists(this.dir, new LinkOption[0])) {
                Files.createDirectories(this.dir, new FileAttribute[0]);
            }
            this.configFiles.clear();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.dir, "*.json");){
                stream.forEach(f -> this.configFiles.add(f.getFileName().toString()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }
}

