/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.screen.configScreen;

import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.shao.valkyrien_space_war.function.util.ModClientUtil;
import net.shao.valkyrien_space_war.input.VsswInputState;
import net.shao.valkyrien_space_war.input.VsswKeyConfigData;

public class KeyCaptureScreen
extends Screen {
    private final int bindingKey;
    private final Consumer<VsswKeyConfigData.CustomBind> callback;
    private double lastMouseX = 0.0;
    private double lastMouseY = 0.0;
    private boolean isFirst;
    private InputBindThread inputBindThread;

    public KeyCaptureScreen(int bindingKey, Consumer<VsswKeyConfigData.CustomBind> callback) {
        super((Component)Component.m_237113_((String)"\u6309\u952e\u7ed1\u5b9a\u4e2d..."));
        this.bindingKey = bindingKey;
        this.callback = callback;
        this.isFirst = true;
        this.inputBindThread = new InputBindThread(this);
        this.inputBindThread.start();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.callback.accept(new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, keyCode));
        return this.exitScreen();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.callback.accept(new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.MOUSE_CLICK, button));
        return this.exitScreen();
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        this.callback.accept(new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.MOUSE_SCROLL, (int)pDelta));
        return this.exitScreen();
    }

    public void m_94757_(double pMouseX, double pMouseY) {
        double[] mousePos = ModClientUtil.getMousePos();
        double mousePosX = mousePos[0];
        double mousePosY = mousePos[1];
        if (this.isFirst) {
            this.isFirst = false;
            this.lastMouseX = mousePosX;
            this.lastMouseY = mousePosY;
        }
        double x_move = mousePosX - this.lastMouseX;
        double y_move = mousePosY - this.lastMouseY;
        int[] windowSize = ModClientUtil.getWindowSize();
        boolean set = false;
        VsswKeyConfigData.InputType inputType = VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X;
        if (Math.abs(x_move) > (double)(windowSize[0] / 8)) {
            inputType = x_move > 0.0 ? VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X : VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NX;
            set = true;
        } else if (Math.abs(y_move) > (double)(windowSize[1] / 8)) {
            inputType = y_move > 0.0 ? VsswKeyConfigData.InputType.MOUSE_MOVEMENT_Y : VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NY;
            set = true;
        }
        if (set) {
            this.callback.accept(new VsswKeyConfigData.CustomBind(inputType, 1.0f, false));
            this.exitScreen();
        }
    }

    public void JoyStickChanged(VsswKeyConfigData.InputType type, Integer jid, int code) {
        if (type == VsswKeyConfigData.InputType.GAMEPAD_BUTTON) {
            this.callback.accept(new VsswKeyConfigData.CustomBind(type, jid, code));
            this.exitScreen();
        } else if (type == VsswKeyConfigData.InputType.GAMEPAD_AXIS) {
            this.callback.accept(new VsswKeyConfigData.CustomBind(type, jid, code, 0.001f, 1.0f));
            this.exitScreen();
        } else if (type == VsswKeyConfigData.InputType.GAMEPAD_AXIS_NEGATIVE) {
            this.callback.accept(new VsswKeyConfigData.CustomBind(type, jid, code, -1.0f, -0.001f));
            this.exitScreen();
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        pGuiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.valkyrien_space_war.start_keybinding").m_7220_((Component)Component.m_237115_((String)VsswInputState.keyNames[this.bindingKey])), this.f_96543_ / 2, this.f_96544_ / 2, 0xFFFFFF);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    private boolean exitScreen() {
        this.inputBindThread.interrupt();
        Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().popGuiLayer());
        this.m_7861_();
        return true;
    }

    private class InputBindThread
    extends Thread {
        private final KeyCaptureScreen parentScreen;

        public InputBindThread(KeyCaptureScreen parentScreen) {
            this.parentScreen = parentScreen;
        }

        @Override
        public void run() {
            CopyOnWriteArrayList<Integer> cList = ModClientUtil.getConnectedJoystickList();
            CopyOnWriteArrayList<Map<String, Object>> oldStates = new CopyOnWriteArrayList<Map<String, Object>>();
            for (Integer index : cList) {
                oldStates.add(ModClientUtil.getJoyState(index));
            }
            while (Minecraft.m_91087_().f_91080_ == this.parentScreen) {
                for (Integer index : cList) {
                    Map<String, Object> newState = ModClientUtil.getJoyState(index);
                    Map<String, Object> stringObjectMap = ModClientUtil.computeStateDiff((Map)oldStates.get(index), newState, 1.0E-4f);
                    Map buttons = (Map)stringObjectMap.get("buttons");
                    Map axes = (Map)stringObjectMap.get("axes");
                    if (!axes.isEmpty()) {
                        Map oldAxis = (Map)((Map)oldStates.get(index)).get("axes");
                        axes.forEach((axisCode, valueFloat) -> {
                            float oldValue = ((Float)oldAxis.get(axisCode)).floatValue();
                            float err = valueFloat.floatValue() - oldValue;
                            if (Math.abs(err) > 0.5f) {
                                VsswKeyConfigData.InputType type = err > 0.0f ? VsswKeyConfigData.InputType.GAMEPAD_AXIS : VsswKeyConfigData.InputType.GAMEPAD_AXIS_NEGATIVE;
                                this.parentScreen.JoyStickChanged(type, index, (int)axisCode);
                                Thread.interrupted();
                            }
                        });
                        continue;
                    }
                    if (buttons.isEmpty()) continue;
                    buttons.forEach((buttonCode, valueByte) -> {
                        if (valueByte > 0) {
                            this.parentScreen.JoyStickChanged(VsswKeyConfigData.InputType.GAMEPAD_BUTTON, index, (int)buttonCode);
                            Thread.interrupted();
                        }
                    });
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

