/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.screen.configScreen;

import com.mojang.blaze3d.vertex.Tesselator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ScrollPanel;

public class ModFileListScrollPanel
extends ScrollPanel {
    private Path dir;
    private List<Button> children;
    private List<Button> deleteButtons = new ArrayList<Button>();
    private int button_height = 15;
    private int padding = 5;

    public ModFileListScrollPanel(Minecraft mc, int width, int height, int top, int left, Path dir, List<Button> children) {
        super(mc, width, height, top, left);
        this.dir = dir;
        this.children = children;
        this.init();
    }

    private void init() {
        int x = this.left + 5;
        int y = this.top + 10;
        for (Button child : this.children) {
            child.m_252865_(x);
            child.m_253211_(y);
            child.m_93674_(this.width - 30);
            child.setHeight(this.button_height);
            this.deleteButtons.add(Button.m_253074_((Component)Component.m_237115_((String)"X"), btn -> {
                this.deleteSelectFile(this.dir.resolve(child.m_6035_().getString()));
                this.children.remove(child);
                this.deleteButtons.remove(btn);
            }).m_252794_(x + (this.width - 30) + 5, y).m_253046_(15, 15).m_253136_());
            y = y + this.button_height + this.padding;
        }
    }

    private void deleteSelectFile(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        try {
            Files.delete(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getButtonHeight() {
        return this.button_height;
    }

    public void setButtonHeight(int button_height) {
        this.button_height = button_height;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setChildren(List<Button> children) {
        this.children = children;
    }

    protected int getContentHeight() {
        return this.children.size() * (this.button_height + this.padding) + this.padding;
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        for (Button child : this.children) {
            child.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
        }
        for (Button deleteButton : this.deleteButtons) {
            deleteButton.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        for (Button btn : this.children) {
            if (!btn.m_5953_(mouseX, mouseY)) continue;
            btn.m_5691_();
            return true;
        }
        for (Button btn : this.deleteButtons) {
            if (!btn.m_5953_(mouseX, mouseY)) continue;
            btn.m_5691_();
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

