/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.screen.configScreen;

import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.shao.valkyrien_space_war.function.render.ModGuiUtil;
import net.shao.valkyrien_space_war.function.util.ModClientUtil;
import net.shao.valkyrien_space_war.input.KeyConfigManager;
import net.shao.valkyrien_space_war.input.VsswInputState;
import net.shao.valkyrien_space_war.input.VsswKeyConfigData;
import net.shao.valkyrien_space_war.screen.configScreen.JsonFileSelectScreen;
import net.shao.valkyrien_space_war.screen.configScreen.KeyCaptureScreen;
import net.shao.valkyrien_space_war.screen.configScreen.ModDialogScreen;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class VSSWConfigScreen
extends Screen {
    private static final int ITEM_HEIGHT = 15;
    private static final int PADDING = 5;
    private AbstractWidget focusedWidget = null;
    private VsswKeyConfigData config;
    private ConfigScrollPanel scrollPanel;
    private HashMap<Integer, HashMap<Integer, Float>> allBindAxisState = new HashMap();
    private HashMap<Integer, HashMap<Integer, Byte>> allBindButtonState = new HashMap();
    private float[] mouseMapping = ModClientUtil.getMouseMapping(1.0f, true);
    private float sd = 0.0f;

    public VSSWConfigScreen() {
        super((Component)Component.m_237115_((String)"gui.valkyrien_space_war.controls_configuration"));
        this.config = KeyConfigManager.loadConfig(KeyConfigManager.getLastConfigFile());
    }

    protected void m_7856_() {
        this.scrollPanel = new ConfigScrollPanel(this.f_96541_, this.f_96543_ - 20, this.f_96544_ - 120, 70, 10);
        if (this.sd != 0.0f) {
            this.scrollPanel.setScrollDistance(this.sd);
        }
        int y = 0;
        for (Map.Entry<Integer, VsswKeyConfigData.CustomBind> entry : this.config.binds.entrySet()) {
            ConfigEntry configEntry = new ConfigEntry(entry.getKey(), entry.getValue(), y);
            this.scrollPanel.addEntry(configEntry);
            y += 20;
        }
        this.m_142416_((GuiEventListener)this.scrollPanel);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.valkyrien_space_war.config_save"), btn -> Minecraft.m_91087_().pushGuiLayer((Screen)new JsonFileSelectScreen((Component)Component.m_237113_((String)"save"), KeyConfigManager.CONTROLS_DIR, b2 -> KeyConfigManager.saveConfig(this.config, b2), true))).m_252794_(this.f_96543_ / 2 - 80, this.f_96544_ - 30).m_253046_(60, 15).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.valkyrien_space_war.config_load"), btn -> Minecraft.m_91087_().pushGuiLayer((Screen)new JsonFileSelectScreen((Component)Component.m_237113_((String)"load"), KeyConfigManager.CONTROLS_DIR, b2 -> {
            this.config = KeyConfigManager.loadConfig(b2);
            this.refreshScreen();
        }, false))).m_252794_(this.f_96543_ / 2 - 10, this.f_96544_ - 30).m_253046_(60, 15).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.valkyrien_space_war.config_reset"), btn -> Minecraft.m_91087_().pushGuiLayer((Screen)new ModDialogScreen("gui.valkyrien_space_war.config_reset_confirm", todo -> {
            if (todo.booleanValue()) {
                this.resetTodefaultConfig();
            }
        }))).m_252794_(this.f_96543_ / 2 + 100, this.f_96544_ - 30).m_253046_(35, 15).m_253136_());
    }

    private void resetTodefaultConfig() {
        this.config = KeyConfigManager.createDefaultConfig();
        KeyConfigManager.saveConfig(this.config, "default.json");
        this.refreshScreen();
    }

    private void refreshScreen() {
        Minecraft.m_91087_().m_6937_(() -> {
            this.sd = this.scrollPanel.getScrollDistance();
            this.m_169413_();
            this.m_7856_();
        });
    }

    private void updateFocusedEditBox(EditBox editBox, double mouseX, double mouseY) {
        this.focusedWidget = editBox;
        editBox.m_93692_(true);
        editBox.m_5716_(mouseX, mouseY);
    }

    private void startBinding(int nameKey, Button btn) {
        ModClientUtil.setMouseToCenter();
        Minecraft.m_91087_().pushGuiLayer((Screen)new KeyCaptureScreen(nameKey, newKeyBind -> {
            this.config.binds.put(nameKey, (VsswKeyConfigData.CustomBind)newKeyBind);
            Minecraft.m_91087_().m_6937_(() -> {
                btn.m_93666_(this.getBindDisplayName((VsswKeyConfigData.CustomBind)newKeyBind));
                this.refreshScreen();
            });
        }));
    }

    private Component getBindDisplayName(VsswKeyConfigData.CustomBind bind) {
        String name = switch (bind.type) {
            default -> throw new IncompatibleClassChangeError();
            case VsswKeyConfigData.InputType.KEYBOARD -> ModClientUtil.getKeyName(bind.code);
            case VsswKeyConfigData.InputType.MOUSE_CLICK -> "Mouse" + bind.code;
            case VsswKeyConfigData.InputType.MOUSE_SCROLL -> "Scroll" + bind.code;
            case VsswKeyConfigData.InputType.GAMEPAD_BUTTON -> "Button " + bind.code;
            case VsswKeyConfigData.InputType.GAMEPAD_HAT -> "hat" + bind.code;
            case VsswKeyConfigData.InputType.GAMEPAD_AXIS -> "Axis " + bind.code;
            case VsswKeyConfigData.InputType.GAMEPAD_AXIS_NEGATIVE -> "-Axis " + bind.code;
            case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X -> "Mouse X";
            case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NX -> "Mouse -X";
            case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_Y -> "Mouse Y";
            case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NY -> "Mouse -Y";
        };
        return Component.m_237115_((String)Objects.requireNonNullElse(name, "gui.valkyrien_space_war.config_unbound"));
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.focusedWidget != null) {
            this.focusedWidget = null;
        } else if (this.focusedWidget != null) {
            return this.focusedWidget.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.focusedWidget != null) {
            return this.focusedWidget.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    private class ConfigScrollPanel
    extends ScrollPanel {
        private List<ConfigEntry> children;
        private int tTop;

        public ConfigScrollPanel(Minecraft mc, int width, int height, int top, int left) {
            super(mc, width, height, top, left);
            this.children = new CopyOnWriteArrayList<ConfigEntry>();
            this.tTop = top - 15;
        }

        protected int getContentHeight() {
            return this.children.size() * 20 + 5;
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            CopyOnWriteArrayList<Integer> connectedJoystickList = ModClientUtil.getConnectedJoystickList();
            for (Integer integer : connectedJoystickList) {
                VSSWConfigScreen.this.allBindAxisState.put(integer, ModClientUtil.getRawBindAxisState(integer));
                VSSWConfigScreen.this.allBindButtonState.put(integer, ModClientUtil.getBindButtonState(integer));
            }
            boolean isFirst = true;
            ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>(this.children);
            for (ConfigEntry entry : entries) {
                int y;
                VsswKeyConfigData.CustomBind bind = entry.bind;
                if (isFirst && (bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X || bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_Y || bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NX || bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NY)) {
                    VSSWConfigScreen.this.mouseMapping = ModClientUtil.getMouseMapping(1.0f, bind.isVelocityMode());
                    isFirst = false;
                }
                if ((y = relativeY + entry.y) <= this.tTop || y >= this.bottom) continue;
                entry.render(guiGraphics, this.left, y, mouseX, mouseY);
            }
        }

        public void addEntry(ConfigEntry entry) {
            Minecraft.m_91087_().m_6937_(() -> this.children.add(entry));
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.m_5953_(mouseX, mouseY)) {
                return false;
            }
            if (super.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            double panelY = (float)this.top - this.scrollDistance;
            for (ConfigEntry entry : this.children) {
                if (!entry.isMouseOver(this.left, (int)panelY, mouseX, mouseY)) continue;
                entry.onClick(mouseX, mouseY);
                return true;
            }
            return false;
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean m_6050_(double mouseX, double mouseY, double scroll) {
            return super.m_6050_(mouseX, mouseY, scroll);
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }

        public void setScrollDistance(float f) {
            this.scrollDistance = f;
        }

        public float getScrollDistance() {
            return this.scrollDistance;
        }
    }

    private class ConfigEntry {
        private final int nameKey;
        private final VsswKeyConfigData.CustomBind bind;
        private final int y;
        private Button bindButton;
        private Button isVelocityMode;
        private EditBox minBox;
        private EditBox maxBox;
        private EditBox mouseSpeedBox;
        private static final Component IS_VELOCITY_MODE_TEXT = Component.m_237113_((String)"Vel Mode");
        private static final Component IS_POSITION_MODE_TEXT = Component.m_237113_((String)"Pos Mode");
        private static final ResourceLocation filledRedTexture = new ResourceLocation("valkyrien_space_war", "textures/gui/bind_gui_fill_red.png");
        private static final ResourceLocation filledBlueTexture = new ResourceLocation("valkyrien_space_war", "textures/gui/bind_gui_fill_blue.png");

        public ConfigEntry(int nameKey, VsswKeyConfigData.CustomBind bind, int y) {
            this.nameKey = nameKey;
            this.bind = bind;
            this.y = y;
            this.initWidgets();
        }

        private void initWidgets() {
            this.bindButton = Button.m_253074_((Component)VSSWConfigScreen.this.getBindDisplayName(this.bind), btn -> VSSWConfigScreen.this.startBinding(this.nameKey, btn)).m_253046_(60, 15).m_253136_();
            if (this.bind.type == VsswKeyConfigData.InputType.GAMEPAD_AXIS || this.bind.type == VsswKeyConfigData.InputType.GAMEPAD_AXIS_NEGATIVE) {
                this.minBox = new EditBox(VSSWConfigScreen.this.f_96547_, 0, 0, 50, 15, (Component)Component.m_237113_((String)"minBox"));
                this.minBox.m_94144_(String.valueOf(this.bind.getMinDeadzone()));
                this.minBox.m_94151_(val -> {
                    float minValue = ModGuiUtil.parseFloat(val);
                    if (Math.abs(minValue) <= 1.0f) {
                        this.bind.setMinDeadzone(minValue);
                    } else {
                        this.bind.setMinDeadzone(0.0f);
                        this.minBox.m_94144_(String.valueOf(this.bind.getMinDeadzone()));
                    }
                });
                this.maxBox = new EditBox(VSSWConfigScreen.this.f_96547_, 0, 0, 50, 15, (Component)Component.m_237113_((String)"maxBox"));
                this.maxBox.m_94144_(String.valueOf(this.bind.getMaxDeadzone()));
                this.maxBox.m_94151_(val -> {
                    float maxValue = ModGuiUtil.parseFloat(val);
                    if (Math.abs(maxValue) <= 1.0f) {
                        this.bind.setMaxDeadzone(maxValue);
                    } else {
                        this.bind.setMaxDeadzone(1.0f);
                        this.maxBox.m_94144_(String.valueOf(this.bind.getMaxDeadzone()));
                    }
                });
            } else if (this.bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X || this.bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_Y || this.bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NX || this.bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NY) {
                this.mouseSpeedBox = new EditBox(VSSWConfigScreen.this.f_96547_, 0, 0, 50, 15, (Component)Component.m_237113_((String)"mouseSpeedBox"));
                this.mouseSpeedBox.m_94144_(String.valueOf(this.bind.getMouseSpeed()));
                this.mouseSpeedBox.m_94151_(val -> this.bind.setMouseSpeed(ModGuiUtil.parseFloat(val)));
                this.isVelocityMode = Button.m_253074_((Component)(this.bind.isVelocityMode() ? IS_VELOCITY_MODE_TEXT : IS_POSITION_MODE_TEXT), btn -> {
                    boolean b = !this.bind.isVelocityMode();
                    this.bind.setVelocityMode(b);
                    VSSWConfigScreen.this.config.syncVelocityMode(b);
                }).m_253046_(75, 15).m_253136_();
            }
        }

        public void render(GuiGraphics guiGraphics, int panelX, int panelY, int mouseX, int mouseY) {
            guiGraphics.m_280430_(VSSWConfigScreen.this.f_96547_, (Component)Component.m_237115_((String)VsswInputState.keyNames[this.nameKey]), panelX + 10, panelY + 4, 0xFFFFFF);
            if (this.bind.jid > -1) {
                guiGraphics.m_280488_(VSSWConfigScreen.this.f_96547_, GLFW.glfwGetJoystickName((int)this.bind.jid), panelX + 380, panelY + 4, 0x999999);
            }
            this.drawInput(guiGraphics, panelX, panelY);
            this.bindButton.m_252865_(panelX + 85);
            this.bindButton.m_253211_(panelY);
            this.bindButton.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
            if (this.minBox != null && this.maxBox != null) {
                this.minBox.m_252865_(panelX + 205);
                this.minBox.m_253211_(panelY);
                this.minBox.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
                this.maxBox.m_252865_(panelX + 265);
                this.maxBox.m_253211_(panelY);
                this.maxBox.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
            } else if (this.mouseSpeedBox != null) {
                this.mouseSpeedBox.m_252865_(panelX + 265);
                this.mouseSpeedBox.m_253211_(panelY);
                this.mouseSpeedBox.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
                this.isVelocityMode.m_252865_(panelX + 325);
                this.isVelocityMode.m_253211_(panelY);
                this.isVelocityMode.m_93666_(this.bind.isVelocityMode() ? IS_VELOCITY_MODE_TEXT : IS_POSITION_MODE_TEXT);
                this.isVelocityMode.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
            }
        }

        private void drawInput(GuiGraphics guiGraphics, int panelX, int panelY) {
            if (this.bind.type == VsswKeyConfigData.InputType.GAMEPAD_AXIS || this.bind.type == VsswKeyConfigData.InputType.GAMEPAD_AXIS_NEGATIVE) {
                HashMap<Integer, Float> inputMap = VSSWConfigScreen.this.allBindAxisState.get(this.bind.jid);
                if (inputMap != null && inputMap.get(this.bind.code) != null) {
                    float mappingResult = ModClientUtil.getBindAxisMapping(this.bind.type, this.bind.getMinDeadzone(), this.bind.getMaxDeadzone(), inputMap.get(this.bind.code).floatValue());
                    if (!this.bind.isBoolean) {
                        this.drawMappingTexture(guiGraphics, panelX, panelY, mappingResult);
                    } else {
                        this.drawMappingTexture(guiGraphics, panelX, panelY, mappingResult == 0.0f ? 0.0f : Math.copySign(mappingResult, 1.0f));
                    }
                    Float rawFloat = inputMap.get(this.bind.code);
                    if (rawFloat.floatValue() > this.bind.getMinDeadzone() && rawFloat.floatValue() < this.bind.getMaxDeadzone()) {
                        guiGraphics.m_280488_(VSSWConfigScreen.this.f_96547_, ModClientUtil.formatFloat6(rawFloat.floatValue()), panelX + 320, panelY + 4, 0xFF4343);
                    } else {
                        guiGraphics.m_280488_(VSSWConfigScreen.this.f_96547_, ModClientUtil.formatFloat6(rawFloat.floatValue()), panelX + 320, panelY + 4, 0x999999);
                    }
                }
            } else if (this.bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X || this.bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_Y || this.bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NX || this.bind.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NY) {
                float mouseX = VSSWConfigScreen.this.mouseMapping[0] * this.bind.getMouseSpeed();
                float mouseY = VSSWConfigScreen.this.mouseMapping[1] * this.bind.getMouseSpeed();
                float mouseMap = switch (this.bind.type) {
                    case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X -> {
                        if (mouseX < 0.0f) {
                            yield 0.0f;
                        }
                        if (mouseX > 1.0f) {
                            yield 1.0f;
                        }
                        yield mouseX;
                    }
                    case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NX -> {
                        if (mouseX > 0.0f) {
                            yield 0.0f;
                        }
                        if (mouseX < -1.0f) {
                            yield 1.0f;
                        }
                        yield -mouseX;
                    }
                    case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_Y -> {
                        if (mouseY < 0.0f) {
                            yield 0.0f;
                        }
                        if (mouseY > 1.0f) {
                            yield 1.0f;
                        }
                        yield mouseY;
                    }
                    case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NY -> {
                        if (mouseY > 0.0f) {
                            yield 0.0f;
                        }
                        if (mouseY < -1.0f) {
                            yield 1.0f;
                        }
                        yield -mouseY;
                    }
                    default -> 0.0f;
                };
                guiGraphics.m_280430_(VSSWConfigScreen.this.f_96547_, (Component)Component.m_237115_((String)"gui.valkyrien_space_war.config_mouse_speed"), panelX + 205, panelY + 4, 0xFFFFFF);
                if (!this.bind.isBoolean) {
                    this.drawMappingTexture(guiGraphics, panelX, panelY, mouseMap);
                } else {
                    this.drawMappingTexture(guiGraphics, panelX, panelY, mouseMap == 0.0f ? 0.0f : Math.copySign(mouseMap, 1.0f));
                }
            } else if (this.bind.type == VsswKeyConfigData.InputType.GAMEPAD_BUTTON) {
                HashMap<Integer, Byte> inputMap = VSSWConfigScreen.this.allBindButtonState.get(this.bind.jid);
                if (inputMap != null && inputMap.get(this.bind.code) != null) {
                    byte mappingResult = inputMap.get(this.bind.code);
                    this.drawMappingTexture(guiGraphics, panelX, panelY, mappingResult > 0 ? 1.0f : 0.0f);
                }
            } else if (this.bind.type == VsswKeyConfigData.InputType.KEYBOARD) {
                byte keyboardKeyState = ModClientUtil.getKeyboardKeyState(this.bind.code);
                this.drawMappingTexture(guiGraphics, panelX, panelY, keyboardKeyState > 0 ? 1.0f : 0.0f);
            } else if (this.bind.type == VsswKeyConfigData.InputType.MOUSE_CLICK) {
                byte mouseButtonState = ModClientUtil.getMouseButtonState(this.bind.code);
                this.drawMappingTexture(guiGraphics, panelX, panelY, mouseButtonState > 0 ? 1.0f : 0.0f);
            }
        }

        private void drawMappingTexture(GuiGraphics guiGraphics, int panelX, int panelY, float mappingResult) {
            if (mappingResult != 0.0f) {
                if (mappingResult > 0.0f) {
                    guiGraphics.m_280218_(filledRedTexture, panelX + 150, panelY + 3, 0, 0, (int)(mappingResult * 50.0f), 10);
                } else {
                    guiGraphics.m_280218_(filledBlueTexture, panelX + 150, panelY + 3, 0, 0, (int)(-mappingResult * 50.0f), 10);
                }
                guiGraphics.m_280488_(VSSWConfigScreen.this.f_96547_, ModClientUtil.formatFloat6(mappingResult), panelX + 150, panelY + 4, 0x999999);
            }
        }

        public boolean isMouseOver(int panelX, int panelY, double mouseX, double mouseY) {
            int entryTop = panelY + this.y;
            int entryBottom = entryTop + 15;
            return mouseY >= (double)entryTop && mouseY <= (double)entryBottom;
        }

        public void onClick(double mouseX, double mouseY) {
            if (VSSWConfigScreen.this.focusedWidget != null) {
                VSSWConfigScreen.this.focusedWidget.m_93692_(false);
            }
            if (this.bindButton.m_5953_(mouseX, mouseY)) {
                this.bindButton.m_5691_();
            } else if (this.isVelocityMode != null && this.isVelocityMode.m_5953_(mouseX, mouseY)) {
                this.isVelocityMode.m_5691_();
            } else if (this.minBox != null && this.minBox.m_5953_(mouseX, mouseY)) {
                VSSWConfigScreen.this.updateFocusedEditBox(this.minBox, mouseX, mouseY);
            } else if (this.maxBox != null && this.maxBox.m_5953_(mouseX, mouseY)) {
                VSSWConfigScreen.this.updateFocusedEditBox(this.maxBox, mouseX, mouseY);
            } else if (this.mouseSpeedBox != null && this.mouseSpeedBox.m_5953_(mouseX, mouseY)) {
                VSSWConfigScreen.this.updateFocusedEditBox(this.mouseSpeedBox, mouseX, mouseY);
            }
        }
    }
}

