/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.screen.ui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class TabManager {
    private final List<Tab> tabs = new ArrayList<Tab>();
    private Tab currentTab;
    private final int x;
    private final int y;
    public static final int TAB_WIDTH = 96;
    public static final int TAB_HEIGHT = 20;

    public TabManager(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void addTab(Tab tab) {
        this.tabs.add(tab);
        if (this.currentTab == null) {
            this.currentTab = tab;
        }
    }

    public void setCurrentTab(Tab tab) {
        this.currentTab = tab;
    }

    public Tab getCurrentTab() {
        return this.currentTab;
    }

    public List<Tab> getTabs() {
        return this.tabs;
    }

    public void renderTabs(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            int tabX = this.x + i * 96;
            tab.renderTab(guiGraphics, tabX, this.y, 96, 20, mouseX, mouseY, tab == this.currentTab);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            int tabX = this.x + i * 96;
            int tabY = this.y;
            if (!(mouseX >= (double)tabX) || !(mouseX < (double)(tabX + 96)) || !(mouseY >= (double)tabY) || !(mouseY < (double)(tabY + 20))) continue;
            this.currentTab = tab;
            return true;
        }
        return false;
    }

    public static abstract class Tab {
        protected final Component title;
        protected final int textWidth;
        protected final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        private static final ResourceLocation IMG = new ResourceLocation("valkyrien_space_war", "textures/gui/tab_top.png");

        public Tab(Component title) {
            this.title = title;
            this.textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)title);
        }

        public abstract void init(int var1, int var2, int var3, int var4);

        public abstract void sendCommand();

        public void renderTab(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, boolean isSelected) {
            if (isSelected) {
                guiGraphics.m_280218_(IMG, x, y, 0, 0, width, height);
            } else {
                guiGraphics.m_280218_(IMG, x, y, 0, 20, width, height);
            }
            int textX = x + (width - this.textWidth) / 2;
            int textY = y + (height - 8) / 2;
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.title, textX, textY, isSelected ? -1 : -6710887);
        }

        public void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        }

        public List<AbstractWidget> getWidgets() {
            return this.widgets;
        }

        public void addWidget(AbstractWidget widget) {
            this.widgets.add(widget);
        }

        public void clearWidgets() {
            this.widgets.clear();
        }

        public void tick() {
        }
    }
}

