/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.sound;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.sound.MovingSoundInstance;

public class LoopSoundController {
    public static final Map<ModConnectorBE, MovingSoundInstance> ACTIVE_SOUNDS = new ConcurrentHashMap<ModConnectorBE, MovingSoundInstance>();

    public static void startOrUpdateLoop(Level level, ModConnectorBE be, SoundEvent sound, float volume, float pitch, boolean isDelay, Vec3 position) {
        if (level != null && !level.f_46443_) {
            return;
        }
        MovingSoundInstance instance = ACTIVE_SOUNDS.get(be);
        if (instance != null) {
            instance.updatePosition(position);
            instance.setVolume(volume);
            instance.setPitch(pitch);
        } else {
            instance = new MovingSoundInstance(sound, volume, pitch, isDelay, position);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)instance);
            ACTIVE_SOUNDS.put(be, instance);
        }
    }

    public static void updatePosition(ModConnectorBE be, Vec3 newPosition) {
        if (!ACTIVE_SOUNDS.containsKey(be)) {
            return;
        }
        ACTIVE_SOUNDS.get(be).updatePosition(newPosition);
    }

    public static void stopLoop(Level level, ModConnectorBE be) {
        if (level == null) {
            return;
        }
        if (!level.f_46443_) {
            return;
        }
        if (ACTIVE_SOUNDS.containsKey(be)) {
            MovingSoundInstance instance = ACTIVE_SOUNDS.get(be);
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)instance);
            ACTIVE_SOUNDS.remove(be);
        }
    }

    public static boolean isPlaying(ModConnectorBE be) {
        return ACTIVE_SOUNDS.containsKey(be) && Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)ACTIVE_SOUNDS.get(be));
    }

    public static void checkAndCleanup() {
        Iterator<Map.Entry<ModConnectorBE, MovingSoundInstance>> iterator = ACTIVE_SOUNDS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ModConnectorBE, MovingSoundInstance> entry = iterator.next();
            ModConnectorBE be = entry.getKey();
            MovingSoundInstance sound = entry.getValue();
            if (Minecraft.m_91087_().f_91073_ != null && !be.m_58901_() && be.getClientShip() != null && Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)sound) && be.m_58898_()) continue;
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)sound);
            iterator.remove();
        }
    }
}

