/*
 * Decompiled with CFR 0.152.
 */
package com.funnyboyroks.mapify;

import com.funnyboyroks.bukkit.Metrics;
import com.funnyboyroks.charts.AdvancedPie;
import com.funnyboyroks.charts.SimplePie;
import com.funnyboyroks.charts.SingleLineChart;
import com.funnyboyroks.mapify.DataHandler;
import com.funnyboyroks.mapify.Listeners;
import com.funnyboyroks.mapify.PluginConfig;
import com.funnyboyroks.mapify.command.CommandManager;
import com.funnyboyroks.mapify.util.Cache;
import com.funnyboyroks.mapify.util.Util;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Mapify
extends JavaPlugin {
    public static Mapify INSTANCE;
    public Cache<URL, Image> imageCache;
    public PluginConfig config;
    public CommandManager commandManager;
    public DataHandler dataHandler;

    public Mapify() {
        INSTANCE = this;
    }

    public void onEnable() {
        try {
            ((CompletableFuture)Util.isLatestVersion().thenAccept(latest -> {
                if (!latest.booleanValue()) {
                    this.getLogger().warning("Mapify has an update!");
                    this.getLogger().warning("Get it from https://modrinth.com/plugin/mapify");
                }
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        Metrics metrics = new Metrics((Plugin)this, 17096);
        metrics.addCustomChart(new SingleLineChart("maps", () -> Mapify.INSTANCE.dataHandler.data.mapData.size()));
        metrics.addCustomChart(new SimplePie("blacklist", () -> "" + Mapify.INSTANCE.config.whitelistIsBlacklist));
        metrics.addCustomChart(new AdvancedPie("whitelist", () -> Mapify.INSTANCE.config.whitelist.stream().collect(Collectors.toMap(k -> k, v -> 1))));
        this.getLogger().info("Metrics loaded.");
        this.dataHandler = new DataHandler();
        int maps = this.dataHandler.data.mapData.size();
        this.getLogger().info("Loaded " + maps + " map" + (maps == 1 ? "" : "s") + ".");
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.commandManager = new CommandManager(this);
        Bukkit.getPluginManager().registerEvents((Listener)new Listeners(), (Plugin)this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> this.dataHandler.trySaveData(false), 6000L, 6000L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> this.dataHandler.trySaveData(true), 75600L, 72000L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this.imageCache::clearExpired, 0L, 72000L);
    }

    public void loadConfig() throws IOException {
        boolean mkdir;
        File imgDir;
        this.reloadConfig();
        this.config = new PluginConfig(INSTANCE);
        if (this.config.saveImages && !(imgDir = Path.of(this.getDataFolder().getPath(), "img").toFile()).exists() && !(mkdir = imgDir.mkdirs())) {
            this.getLogger().severe("Unable to create img directory.");
        }
        if (this.imageCache == null) {
            this.imageCache = new Cache<URL, Image>((long)this.config.cacheDuration * 60L * 1000L, Util::getImage);
        } else {
            this.imageCache.setCacheDuration(this.config.cacheDuration * 60 * 1000);
        }
    }

    public void onDisable() {
        try {
            this.dataHandler.saveData(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

