/*
 * Decompiled with CFR 0.152.
 */
package com.funnyboyroks.mapify;

import com.funnyboyroks.mapify.Mapify;
import com.tchristofferson.configupdater.ConfigUpdater;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class PluginConfig {
    private final File configFile;
    public boolean whitelistDisabled;
    public boolean whitelistIsBlacklist;
    public List<String> whitelist;
    public boolean nonopMapify;
    public int cacheDuration;
    public boolean httpsOnly;
    public boolean saveImages;
    public boolean debug;
    public int cooldown;
    public int opCooldown;
    public String maxSize;

    public PluginConfig(Mapify plugin) throws IOException {
        plugin.saveDefaultConfig();
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        this.update();
        FileConfiguration config = plugin.getConfig();
        this.whitelistDisabled = config.getBoolean("whitelist-disabled", false);
        this.whitelistIsBlacklist = config.getBoolean("whitelist-is-blacklist", true);
        this.whitelist = config.getStringList("whitelist");
        this.nonopMapify = config.getBoolean("non-op-mapify");
        this.cacheDuration = config.getInt("cache-duration", 60);
        this.httpsOnly = config.getBoolean("https-only", true);
        this.saveImages = config.getBoolean("save-images", false);
        this.debug = config.getBoolean("debug-logging", false);
        this.cooldown = config.getInt("cooldown", 0);
        this.opCooldown = config.getInt("op-cooldown", 0);
        this.maxSize = config.getString("max-size", "");
    }

    public void update() throws IOException {
        ConfigUpdater.update((Plugin)Mapify.INSTANCE, "config.yml", this.configFile, new String[0]);
    }

    public void save(Mapify plugin) {
        FileConfiguration config = plugin.getConfig();
        config.set("whitelist-disabled", (Object)this.whitelistDisabled);
        config.set("whitelist-is-blacklist", (Object)this.whitelistIsBlacklist);
        config.set("whitelist", this.whitelist);
        config.set("non-op-mapify", (Object)this.nonopMapify);
        config.set("cache-duration", (Object)this.cacheDuration);
        config.set("https-only", (Object)this.httpsOnly);
        config.set("save-images", (Object)this.saveImages);
        config.set("debug-logging", (Object)this.debug);
        config.set("cooldown", (Object)this.cooldown);
        config.set("op-cooldown", (Object)this.opCooldown);
        config.set("max-size", (Object)this.maxSize);
        plugin.saveConfig();
    }

    public List<Diff> diff(PluginConfig neu) {
        ArrayList<Diff> out = new ArrayList<Diff>();
        if (this.whitelistDisabled != neu.whitelistDisabled) {
            out.add(new Diff("whitelist-disabled", this.whitelistDisabled, neu.whitelistDisabled));
        }
        if (this.whitelistIsBlacklist != neu.whitelistIsBlacklist) {
            out.add(new Diff("whitelist-is-blacklist", this.whitelistIsBlacklist, neu.whitelistIsBlacklist));
        }
        if (!this.whitelist.equals(neu.whitelist)) {
            out.add(new Diff("whitelist", this.whitelist, neu.whitelist));
        }
        if (this.nonopMapify != neu.nonopMapify) {
            out.add(new Diff("non-op-mapify", this.nonopMapify, neu.nonopMapify));
        }
        if (this.cacheDuration != neu.cacheDuration) {
            out.add(new Diff("cache-duration", this.cacheDuration, neu.cacheDuration));
        }
        if (this.httpsOnly != neu.httpsOnly) {
            out.add(new Diff("https-only", this.httpsOnly, neu.httpsOnly));
        }
        if (this.saveImages != neu.saveImages) {
            out.add(new Diff("save-images", this.saveImages, neu.saveImages));
        }
        if (this.debug != neu.debug) {
            out.add(new Diff("debug-logging", this.debug, neu.debug));
        }
        if (this.cooldown != neu.cooldown) {
            out.add(new Diff("cooldown", this.cooldown, neu.cooldown));
        }
        if (this.opCooldown != neu.opCooldown) {
            out.add(new Diff("op-cooldown", this.opCooldown, neu.opCooldown));
        }
        if (!this.maxSize.equals(neu.maxSize)) {
            out.add(new Diff("max-size", this.maxSize, neu.maxSize));
        }
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PluginConfig { ");
        sb.append("whitelistIsBlacklist: ");
        sb.append(this.whitelistIsBlacklist);
        sb.append(", ");
        sb.append("whitelist: ");
        sb.append(this.whitelist);
        sb.append(", ");
        sb.append("cacheDuration: ");
        sb.append(this.cacheDuration);
        sb.append(", ");
        sb.append("httpsOnly: ");
        sb.append(this.httpsOnly);
        sb.append(", ");
        sb.append("saveImages: ");
        sb.append(this.saveImages);
        sb.append(", ");
        sb.append("debug: ");
        sb.append(this.debug);
        sb.append(", ");
        sb.append("cooldown: ");
        sb.append(this.cooldown);
        sb.append(", ");
        sb.append("opCooldown: ");
        sb.append(this.opCooldown);
        sb.append(", ");
        sb.append("maxSize: ");
        sb.append(this.maxSize);
        sb.append(", ");
        sb.append("}");
        return sb.toString();
    }

    public static class Keys {
        public static final String WHITELIST_DISABLED = "whitelist-disabled";
        public static final String WHITELIST_IS_BLACKLIST = "whitelist-is-blacklist";
        public static final String WHITELIST = "whitelist";
        public static final String NON_OP_MAPIFY = "non-op-mapify";
        public static final String CACHE_DURATION = "cache-duration";
        public static final String HTTPS_ONLY = "https-only";
        public static final String SAVE_IMAGES = "save-images";
        public static final String DEBUG_LOGGING = "debug-logging";
        public static final String COOLDOWN = "cooldown";
        public static final String OP_COOLDOWN = "op-cooldown";
        public static final String MAX_SIZE = "max-size";
        public static final String[] keys = new String[]{"whitelist-disabled", "whitelist-is-blacklist", "whitelist", "non-op-mapify", "cache-duration", "https-only", "save-images", "debug-logging", "cooldown", "op-cooldown", "max-size"};

        public static String[] optionsForKey(String key) {
            String[] stringArray;
            String[] bool = new String[]{"true", "false"};
            switch (key) {
                case "whitelist-disabled": {
                    stringArray = bool;
                    break;
                }
                case "whitelist-is-blacklist": {
                    stringArray = bool;
                    break;
                }
                case "whitelist": {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "add";
                    stringArray = stringArray2;
                    stringArray2[1] = "remove";
                    break;
                }
                case "non-op-mapify": {
                    stringArray = bool;
                    break;
                }
                case "cache-duration": {
                    stringArray = new String[]{};
                    break;
                }
                case "https-only": {
                    stringArray = bool;
                    break;
                }
                case "save-images": {
                    stringArray = bool;
                    break;
                }
                case "debug-logging": {
                    stringArray = bool;
                    break;
                }
                case "cooldown": {
                    stringArray = new String[]{};
                    break;
                }
                case "op-cooldown": {
                    stringArray = new String[]{};
                    break;
                }
                case "max-size": {
                    stringArray = new String[]{};
                    break;
                }
                default: {
                    stringArray = new String[]{};
                }
            }
            return stringArray;
        }
    }

    public static class Diff {
        public String key;
        public String old;
        public String neu;

        public <T> Diff(String key, T old, T neu) {
            this.key = key;
            this.old = old == null ? null : old.toString();
            this.neu = neu == null ? null : neu.toString();
        }
    }
}

