/*
 * Decompiled with CFR 0.152.
 */
package com.funnyboyroks.mapify.command;

import com.funnyboyroks.mapify.FetchImageException;
import com.funnyboyroks.mapify.Mapify;
import com.funnyboyroks.mapify.PluginConfig;
import com.funnyboyroks.mapify.util.Util;
import java.awt.Point;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CommandMapify
implements CommandExecutor,
TabCompleter {
    private static final Map<UUID, Long> cooldownMap = new HashMap<UUID, Long>();

    public boolean reloadConfig(CommandSender sender) {
        PluginConfig oldConfig = Mapify.INSTANCE.config;
        try {
            Mapify.INSTANCE.reloadConfig();
            Mapify.INSTANCE.loadConfig();
        }
        catch (IOException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "There was an error reading the config: %s".formatted(e.getMessage()));
            e.printStackTrace();
            return true;
        }
        List<PluginConfig.Diff> diff = oldConfig.diff(Mapify.INSTANCE.config);
        if (diff.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded successfully with no changes.");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded successfully.");
            for (PluginConfig.Diff d : diff) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + d.key + ": " + String.valueOf(ChatColor.AQUA) + d.old + String.valueOf(ChatColor.YELLOW) + " \u2192 " + String.valueOf(ChatColor.AQUA) + d.neu);
            }
        }
        Mapify.INSTANCE.getCommand("mapify").setPermission(Mapify.INSTANCE.config.nonopMapify ? null : "mapify.command.mapify");
        return true;
    }

    public boolean commandConfig(CommandSender sender, String[] args) {
        String field;
        if (args.length < 2) {
            return false;
        }
        switch (field = args[0]) {
            case "whitelist-disabled": {
                if (args[1].equalsIgnoreCase("true")) {
                    Mapify.INSTANCE.config.whitelistDisabled = true;
                    break;
                }
                if (args[1].equalsIgnoreCase("false")) {
                    Mapify.INSTANCE.config.whitelistDisabled = false;
                    break;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "%s may only be set to `true` or `false`".formatted(field));
                return true;
            }
            case "whitelist-is-blacklist": {
                if (args[1].equalsIgnoreCase("true")) {
                    Mapify.INSTANCE.config.whitelistIsBlacklist = true;
                    break;
                }
                if (args[1].equalsIgnoreCase("false")) {
                    Mapify.INSTANCE.config.whitelistIsBlacklist = false;
                    break;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "%s may only be set to `true` or `false`".formatted(field));
                return true;
            }
            case "whitelist": {
                String host;
                if (args.length < 3) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /mapify config %s <add|remove> <domain>".formatted(field));
                    return true;
                }
                String url = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                URL url2 = Util.getUrl(url);
                String string = host = url2 == null ? url : url2.getHost();
                if (args[1].equalsIgnoreCase("add")) {
                    List<String> whitelist = Mapify.INSTANCE.config.whitelist;
                    if (whitelist.contains(host)) break;
                    whitelist.add(host);
                    break;
                }
                if (args[1].equalsIgnoreCase("remove")) {
                    Mapify.INSTANCE.config.whitelist.remove(host);
                    break;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "%s may only perform `add` or `remove`".formatted(field));
                return true;
            }
            case "non-op-mapify": {
                if (args[1].equalsIgnoreCase("true")) {
                    Mapify.INSTANCE.config.nonopMapify = true;
                } else if (args[1].equalsIgnoreCase("false")) {
                    Mapify.INSTANCE.config.nonopMapify = false;
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "%s may only be set to `true` or `false`".formatted(field));
                    return true;
                }
                Mapify.INSTANCE.getCommand("mapify").setPermission(Mapify.INSTANCE.config.nonopMapify ? null : "mapify.command.mapify");
                break;
            }
            case "cache-duration": {
                Integer n = Util.tryParseInt(args[1]);
                if (n == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "%s may only be set to an integer.".formatted(field));
                    return true;
                }
                Mapify.INSTANCE.config.cacheDuration = n;
                break;
            }
            case "save-images": {
                if (args[1].equalsIgnoreCase("true")) {
                    Mapify.INSTANCE.config.saveImages = true;
                    break;
                }
                if (args[1].equalsIgnoreCase("false")) {
                    Mapify.INSTANCE.config.saveImages = false;
                    break;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "%s may only be set to `true` or `false`".formatted(field));
                return true;
            }
            case "debug-logging": {
                if (args[1].equalsIgnoreCase("true")) {
                    Mapify.INSTANCE.config.debug = true;
                    break;
                }
                if (args[1].equalsIgnoreCase("false")) {
                    Mapify.INSTANCE.config.debug = false;
                    break;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "%s may only be set to `true` or `false`".formatted(field));
                return true;
            }
            case "cooldown": {
                Integer n = Util.tryParseInt(args[1]);
                if (n == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "%s may only be set to an integer.".formatted(field));
                    return true;
                }
                Mapify.INSTANCE.config.cooldown = n;
                break;
            }
            case "op-cooldown": {
                Integer n = Util.tryParseInt(args[1]);
                if (n == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "%s may only be set to an integer.".formatted(field));
                    return true;
                }
                Mapify.INSTANCE.config.opCooldown = n;
                break;
            }
            case "max-size": {
                Mapify.INSTANCE.config.maxSize = args[1];
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown field '%s'".formatted(field));
            }
        }
        Mapify.INSTANCE.config.save(Mapify.INSTANCE);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Config updated!");
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!Mapify.INSTANCE.config.nonopMapify && !sender.hasPermission("mapify.command.mapify")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to run this command.");
            return true;
        }
        if (args.length == 1 && args[0].equals("reload")) {
            if (!sender.hasPermission("mapify.command.mapify.reload")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to run this command.");
                return true;
            }
            return this.reloadConfig(sender);
        }
        if (args.length >= 1 && args[0].equals("config")) {
            if (!sender.hasPermission("mapify.command.mapify.config")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to run this command.");
                return true;
            }
            return this.commandConfig(sender, Arrays.copyOfRange(args, 1, args.length));
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used in-game.");
            return true;
        }
        Player player = (Player)sender;
        Long cdEnd = cooldownMap.get(player.getUniqueId());
        if (cdEnd != null) {
            long current = System.currentTimeMillis();
            long remaining = (cdEnd - current) / 1000L;
            if (remaining > 0L) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You can use this command again in %d seconds.".formatted(remaining));
                return true;
            }
        }
        if (args.length == 0 || args.length > 2) {
            return false;
        }
        URL url = Util.getUrl(args[0]);
        if (url == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Please specify a valid URL.");
            return true;
        }
        if (!Util.isAllowed(url)) {
            if (Util.isOperator((CommandSender)player)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This domain is not whitelisted in your Mapify config.");
                player.sendMessage(String.valueOf(ChatColor.RED) + "Run " + String.valueOf(ChatColor.DARK_RED) + "/mapify config whitelist add " + url.getHost() + String.valueOf(ChatColor.RED) + " to automatically add it to the config.");
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This is not a valid domain, please contact your server administrators if you believe this is an issue.");
            }
            return true;
        }
        if (!url.getProtocol().equalsIgnoreCase("https") && Mapify.INSTANCE.config.httpsOnly) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This URL is not https. You must use a URL with https.");
            return true;
        }
        Point dims = new Point(1, 1);
        if (args.length == 2 && (dims = Util.getDimensions(args[1])) == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid dimensions, must be in the form WIDTHxHEIGHT: \"1x1\".");
            return true;
        }
        if (!Util.dimsMatch(dims, Mapify.INSTANCE.config.maxSize)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Dimensions speified are too large.");
            return true;
        }
        try {
            int cooldown;
            List<ItemStack> stacks = Util.getMaps(args[0], dims.x, dims.y);
            if (stacks == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This URL does not have an image.");
                return true;
            }
            int n = cooldown = sender.hasPermission("mapify.operator") ? Mapify.INSTANCE.config.opCooldown : Mapify.INSTANCE.config.cooldown;
            if (cooldown > 0) {
                long end = System.currentTimeMillis() + (long)(cooldown * 1000);
                cooldownMap.put(player.getUniqueId(), end);
                Bukkit.getScheduler().runTaskLater((Plugin)Mapify.INSTANCE, () -> cooldownMap.remove(player.getUniqueId()), (long)cooldown * 20L);
            }
            Util.giveItems(player, (ItemStack[])stacks.toArray(ItemStack[]::new));
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Given " + stacks.size() + " map" + (stacks.size() == 1 ? "." : "s."));
        }
        catch (FetchImageException.NotFoundException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Not file found at URL.");
        }
        catch (FetchImageException.UnknownHostException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown host '" + e.url.getHost() + "'. This could be because it's invalid, or the server does not have access to it. Perhaps try a different URL.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        return switch (args.length) {
            case 1 -> {
                ArrayList<String> options = new ArrayList<String>();
                if (sender.hasPermission("mapify.command.mapify.reload")) {
                    options.add("reload");
                }
                if (sender.hasPermission("mapify.command.mapify.config")) {
                    options.add("config");
                }
                options.removeIf(s -> !s.startsWith(args[0]));
                yield options;
            }
            case 2 -> {
                switch (args[0]) {
                    case "reload": {
                        yield Collections.emptyList();
                    }
                    case "config": {
                        if (sender.hasPermission("mapify.command.mapify.config")) {
                            yield Arrays.stream(PluginConfig.Keys.keys).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
                        }
                        yield List.of("1x1");
                    }
                }
                yield List.of("1x1");
            }
            case 3 -> {
                switch (args[0]) {
                    case "config": {
                        if (sender.hasPermission("mapify.command.mapify.config")) {
                            yield Arrays.stream(PluginConfig.Keys.optionsForKey(args[1])).filter(s -> s.startsWith(args[2])).collect(Collectors.toList());
                        }
                        yield Collections.emptyList();
                    }
                }
                yield Collections.emptyList();
            }
            default -> Collections.emptyList();
        };
    }
}

