/*
 * Decompiled with CFR 0.152.
 */
package com.funnyboyroks.mapify.command;

import com.funnyboyroks.mapify.util.Util;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class CommandRefreshMaps
implements CommandExecutor,
TabCompleter {
    private ItemStack[] getItemFramesInRadius(Player player, int radius) {
        return (ItemStack[])player.getNearbyEntities((double)radius, (double)radius, (double)radius).stream().filter(e -> e instanceof ItemFrame).map(e -> ((ItemFrame)e).getItem()).filter(i -> !i.getType().isAir()).toArray(ItemStack[]::new);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        ItemStack[] items;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be run in-game.");
            return true;
        }
        if (!sender.hasPermission("mapify.command.refreshmaps")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to run this command.");
            return true;
        }
        if (args.length > 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /refreshmaps [radius]");
            return true;
        }
        int radius = -1;
        if (args.length == 1) {
            try {
                radius = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /refreshmaps [radius]");
                return true;
            }
        }
        Player player = (Player)sender;
        int count = 0;
        for (ItemStack item : items = radius == -1 ? player.getInventory().getContents() : this.getItemFramesInRadius(player, radius)) {
            MapMeta meta;
            MapView view;
            MapRenderer renderer;
            if (item == null || item.getType() != Material.FILLED_MAP || (renderer = Util.getRenderer(view = (meta = (MapMeta)item.getItemMeta()).getMapView())) == null) continue;
            view.getRenderers().forEach(arg_0 -> ((MapView)view).removeRenderer(arg_0));
            view.addRenderer(renderer);
            ++count;
        }
        if (count == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No maps found to be refreshed.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Refreshed " + count + " map" + (count == 1 ? "" : "s") + ".");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        return Collections.emptyList();
    }
}

