/*
 * Decompiled with CFR 0.152.
 */
package com.funnyboyroks.mapify.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class Cache<K, V> {
    private final Map<K, CacheItem> map = new HashMap<K, CacheItem>();
    private final Function<K, V> getter;
    private long cacheDuration;

    public Cache(long cacheDurationMs, Function<K, V> getter) {
        this.cacheDuration = cacheDurationMs;
        this.getter = getter;
    }

    public V get(K key) {
        CacheItem item;
        if (this.map.containsKey(key) && !(item = this.map.get(key)).isExpired()) {
            item.refresh();
            return item.value;
        }
        V newValue = this.getter.apply(key);
        this.map.put(key, new CacheItem(newValue));
        return newValue;
    }

    public int clearExpired() {
        AtomicInteger count = new AtomicInteger(0);
        this.map.entrySet().removeIf(value -> {
            if (((CacheItem)value.getValue()).isExpired()) {
                count.incrementAndGet();
                return true;
            }
            return false;
        });
        return count.get();
    }

    public long getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(long cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    private class CacheItem {
        private long insertedTime = System.currentTimeMillis();
        private final V value;

        public CacheItem(V value) {
            this.value = value;
        }

        public void refresh() {
            this.insertedTime = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.insertedTime > Cache.this.cacheDuration;
        }
    }
}

