package de.keksuccino.spiffyhud.customization.actions.marker;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.spiffyhud.customization.marker.MarkerStorage;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditMarkerAction extends Action {

    private static final Logger LOGGER = LogManager.getLogger();

    public EditMarkerAction() {
        super("spiffyhud_edit_marker");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        MarkerActionConfig config = MarkerActionConfig.parse(value);
        if (config == null) {
            LOGGER.error("[SPIFFYHUD] EditMarkerAction received malformed configuration.");
            return;
        }
        String markerName = config.getMarkerName();
        if (!config.hasValidTarget() || markerName.isBlank() || !config.hasValidMarkerName()) {
            LOGGER.error("[SPIFFYHUD] EditMarkerAction is missing required data: Invalid marker name");
            return;
        }
        boolean success = MarkerStorage.editMarker(config.targetElementIdentifier, markerName, marker -> {
            marker.setName(config.uniqueMarkerName);
            marker.setColor(config.colorHex);
            marker.setDotTexture(config.dotTexture);
            marker.setNeedleTexture(config.needleTexture);
            marker.setShowAsNeedle(config.showAsNeedle);
            marker.setMarkerPosX(config.positionX);
            marker.setMarkerPosZ(config.positionZ);
        });
        if (!success) {
            LOGGER.error("[SPIFFYHUD] Failed to edit marker '{}' in group '{}'.", markerName, config.targetElementIdentifier);
        }
    }

    @Override
    public @NotNull class_2561 getActionDisplayName() {
        return class_2561.method_43471("spiffyhud.actions.edit_marker");
    }

    @Override
    public @NotNull class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("spiffyhud.actions.edit_marker.desc");
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43473();
    }

    @Override
    public String getValueExample() {
        return MarkerActionConfig.defaultConfig().serialize();
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull ActionInstance instance) {
        MarkerActionConfig config = MarkerActionConfig.parse(instance.value);
        if (config == null) {
            config = MarkerActionConfig.defaultConfig();
        }
        MarkerEditorScreen screen = new MarkerEditorScreen(
                class_2561.method_43471("spiffyhud.actions.edit_marker.editor"),
                config,
                serialized -> {
                    if (serialized != null) {
                        instance.value = serialized;
                    }
                    class_310.method_1551().method_1507(parentScreen);
                }
        );
        class_310.method_1551().method_1507(screen);
    }

}
