package de.keksuccino.spiffyhud.customization.placeholders;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.spiffyhud.util.level.EntityNbtUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class PlayerNbtDataPlaceholder extends Placeholder {

    public PlayerNbtDataPlaceholder() {
        super("player_nbt_data");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_746 e = class_310.method_1551().field_1724;
        if (e != null) {
            String path = dps.values.get("path");
            if (path != null) {
                String value = EntityNbtUtils.getNbtString(e, path);
                if (value == null) return "§cINVALID NBT PATH!";
                return value;
            }
        } else {
            return "§cNOT IN A WORLD!";
        }
        return "§cERROR!";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("path");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("spiffyhud.placeholders.player_nbt_data");
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("spiffyhud.placeholders.player_nbt_data.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<>();
        values.put("path", "path_to_nbt");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

}
