package de.keksuccino.spiffyhud.mixin.mixins.fabric.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.customization.SpiffyGui;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.VanillaHudElements;
import de.keksuccino.spiffyhud.customization.elements.eraser.EraserElement;
import de.keksuccino.spiffyhud.customization.elements.overlayremover.OverlayRemoverElement;
import de.keksuccino.spiffyhud.util.rendering.exclusion.ExclusionAreaUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1316;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_337;
import net.minecraft.class_437;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_329.class)
public abstract class MixinGui {

    @Shadow private class_2561 overlayMessageString;
    @Shadow private class_2561 title;
    @Shadow private class_2561 subtitle;

    @Unique private static final Logger LOGGER_SPIFFY = LogManager.getLogger();
    @Unique private SpiffyGui spiffyGui = null;
    @Unique private int aggressionLevelNormalCount_Spiffy = 0;
    @Unique private int aggressionLevelAggressiveCount_Spiffy = 0;
    @Unique private class_2561 cached_overlayMessageString_Spiffy = null;
    @Unique private class_2561 cached_title_Spiffy = null;
    @Unique private class_2561 cached_subtitle_Spiffy = null;

    @Shadow protected abstract int getVehicleMaxHearts(class_1309 $$0);

    @Shadow protected abstract class_1309 getPlayerVehicleWithHealth();

    @Shadow @Final private static class_2960 PUMPKIN_BLUR_LOCATION;

    @Shadow @Final private static class_2960 POWDER_SNOW_OUTLINE_LOCATION;

    /**
     * @reason Apply eraser exclusion areas before Vanilla rendering begins.
     */
    @Inject(method = "render", at = @At("HEAD"), order = -1000)
    private void before_render_Spiffy(class_332 graphics, float partialTick, CallbackInfo info) {

        this.aggressionLevelNormalCount_Spiffy = 0;
        this.aggressionLevelAggressiveCount_Spiffy = 0;

        if (this.spiffyGui == null) this.spiffyGui = SpiffyGui.INSTANCE;

        class_310 minecraft = class_310.method_1551();
        class_437 previousScreen = minecraft.field_1755;
        SpiffyOverlayScreen overlayScreen = null;
        boolean swappedScreen = false;

        try {
            overlayScreen = this.spiffyGui.getOverlayScreen();
            if ((overlayScreen != null) && (previousScreen != overlayScreen)) {
                minecraft.field_1755 = overlayScreen;
                swappedScreen = true;
            }
            ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen((overlayScreen != null) ? overlayScreen : SpiffyUtils.DUMMY_SPIFFY_OVERLAY_SCREEN);
            if (layer != null) {
                for (AbstractElement abstractElement : layer.allElements) {
                    if ((abstractElement instanceof EraserElement eraser) && eraser.shouldRender() && (eraser.aggressionLevel == EraserElement.AggressionLevel.AGGRESSIVE)) {
                        this.aggressionLevelAggressiveCount_Spiffy++;
                        ExclusionAreaUtil.pushExclusionArea(graphics, eraser.getAbsoluteX(), eraser.getAbsoluteY(), eraser.getAbsoluteX() + eraser.getAbsoluteWidth(), eraser.getAbsoluteY() + eraser.getAbsoluteHeight());
                    }
                }
                for (AbstractElement abstractElement : layer.allElements) {
                    if ((abstractElement instanceof EraserElement eraser) && eraser.shouldRender() && (eraser.aggressionLevel == EraserElement.AggressionLevel.NORMAL)) {
                        this.aggressionLevelNormalCount_Spiffy++;
                        ExclusionAreaUtil.pushExclusionArea(graphics, eraser.getAbsoluteX(), eraser.getAbsoluteY(), eraser.getAbsoluteX() + eraser.getAbsoluteWidth(), eraser.getAbsoluteY() + eraser.getAbsoluteHeight());
                    }
                }
            }
        } catch (Exception ex) {
            LOGGER_SPIFFY.error("[SPIFFY HUD] Failed to apply Eraser element areas to Gui!", ex);
        } finally {
            if (swappedScreen) {
                minecraft.field_1755 = previousScreen;
            }
        }

    }

    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/ChatComponent;render(Lnet/minecraft/client/gui/GuiGraphics;III)V"))
    private void before_renderChat_in_render_Spiffy(class_332 graphics, float partial, CallbackInfo info) {

        while (this.aggressionLevelNormalCount_Spiffy > 0) {
            ExclusionAreaUtil.popExclusionArea(graphics);
            this.aggressionLevelNormalCount_Spiffy--;
        }

        if (this.spiffyGui == null) this.spiffyGui = SpiffyGui.INSTANCE;

        if (!class_310.method_1551().field_1690.field_1842) {
            RenderSystem.enableBlend();
            graphics.method_51448().method_22903();
            this.spiffyGui.method_25394(graphics, -10000000, -10000000, partial);
            graphics.method_51448().method_22909();
            RenderSystem.disableBlend();
        }

    }

    @Inject(method = "render", at = @At("TAIL"), order = 20000)
    private void after_render_Spiffy(class_332 graphics, float partial, CallbackInfo info) {

        while (this.aggressionLevelAggressiveCount_Spiffy > 0) {
            ExclusionAreaUtil.popExclusionArea(graphics);
            this.aggressionLevelAggressiveCount_Spiffy--;
        }

    }

    /**
     * @reason Hide the hotbar when hidden by Spiffy HUD.
     */
    @Inject(method = "renderHotbar", at = @At(value = "HEAD"), cancellable = true)
    private void before_renderHotbarAndDecorations_Spiffy(float partialTick, class_332 guiGraphics, CallbackInfo info) {
        if (VanillaHudElements.isHidden(VanillaHudElements.HOTBAR_IDENTIFIER)) info.cancel();
    }

    /**
     * @reason Hide the jump meter when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderJumpMeter(Lnet/minecraft/world/entity/PlayerRideableJumping;Lnet/minecraft/client/gui/GuiGraphics;I)V"))
    private boolean wrap_renderJumpMeter_in_render_Spiffy(class_329 instance, class_1316 $$0, class_332 $$1, int $$2) {
        return !VanillaHudElements.isHidden(VanillaHudElements.JUMP_METER_IDENTIFIER);
    }

    /**
     * @reason Hide the EXP bar when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderExperienceBar(Lnet/minecraft/client/gui/GuiGraphics;I)V"))
    private boolean wrap_renderExperienceBar_in_render_Spiffy(class_329 instance, class_332 $$0, int $$1) {
        return !VanillaHudElements.isHidden(VanillaHudElements.EXPERIENCE_BAR_IDENTIFIER);
    }

    /**
     * @reason Hide the selected item name when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;)V"))
    private boolean wrap_renderSelectedItemName_in_render_Spiffy(class_329 instance, class_332 $$0) {
        return !VanillaHudElements.isHidden(VanillaHudElements.SELECTED_ITEM_NAME_IDENTIFIER);
    }

    /**
     * @reason Hide the scoreboard sidebar when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;displayScoreboardSidebar(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/scores/Objective;)V"))
    private boolean wrap_displayScoreboardSidebar_in_render_Spiffy(class_329 instance, class_332 $$0, class_266 $$1) {
        return !VanillaHudElements.isHidden(VanillaHudElements.SCOREBOARD_SIDEBAR_IDENTIFIER);
    }

    /**
     * @reason Hide the crosshair when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderCrosshair(Lnet/minecraft/client/gui/GuiGraphics;)V"))
    private boolean wrap_renderCrosshair_in_render_Spiffy(class_329 instance, class_332 $$0) {
        return !VanillaHudElements.isHidden(VanillaHudElements.CROSSHAIR_IDENTIFIER);
    }

    /**
     * @reason Hide the boss overlay when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/BossHealthOverlay;render(Lnet/minecraft/client/gui/GuiGraphics;)V"))
    private boolean wrap_BossOverlay_render_in_render_Spiffy(class_337 instance, class_332 guiGraphics) {
        return !VanillaHudElements.isHidden(VanillaHudElements.BOSS_BARS_IDENTIFIER);
    }

    /**
     * @reason Hide the mount health bar when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderVehicleHealth(Lnet/minecraft/client/gui/GuiGraphics;)V"))
    private boolean wrap_renderVehicleHealth_in_render_Spiffy(class_329 instance, class_332 $$0) {
        return !VanillaHudElements.isHidden(VanillaHudElements.MOUNT_HEALTH_BAR_IDENTIFIER);
    }

    /**
     * @reason Hide the overlay message, title and subtitle when hidden by Spiffy HUD.
     */
    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderEffects(Lnet/minecraft/client/gui/GuiGraphics;)V", shift = At.Shift.AFTER))
    private void after_renderEffects_in_render_Spiffy(class_332 graphics, float partial, CallbackInfo info) {
        this.cached_overlayMessageString_Spiffy = this.overlayMessageString;
        this.cached_title_Spiffy = this.title;
        this.cached_subtitle_Spiffy = this.subtitle;
        if (VanillaHudElements.isHidden(VanillaHudElements.OVERLAY_MESSAGE_IDENTIFIER)) this.overlayMessageString = null;
        if (VanillaHudElements.isHidden(VanillaHudElements.TITLE_IDENTIFIER)) this.title = null;
        if (VanillaHudElements.isHidden(VanillaHudElements.SUBTITLE_IDENTIFIER)) this.subtitle = null;
    }

    /**
     * @reason Restore the overlay message, title and subtitle.
     */
    @Inject(method = "render", at = @At("RETURN"))
    private void after_render_restore_fields_Spiffy(class_332 graphics, float partial, CallbackInfo info) {
        this.overlayMessageString = this.cached_overlayMessageString_Spiffy;
        this.title = this.cached_title_Spiffy;
        this.subtitle = this.cached_subtitle_Spiffy;
    }

    /**
     * @reason Hide the player armor bar when hidden by Spiffy HUD.
     */
    @WrapOperation(method = "renderPlayerHealth", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;getArmorValue()I"))
    private int wrap_getArmorValue_in_renderPlayerHealth_Spiffy(class_1657 instance, Operation<Integer> original) {
        if (VanillaHudElements.isHidden(VanillaHudElements.ARMOR_BAR_IDENTIFIER)) return 0;
        return original.call(instance);
    }

    /**
     * @reason Hide the player food bar when hidden by Spiffy HUD.
     */
    @WrapOperation(method = "renderPlayerHealth", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;getVehicleMaxHearts(Lnet/minecraft/world/entity/LivingEntity;)I"))
    private int wrap_getVehicleMaxHearts_in_renderPlayerHealth_Spiffy(class_329 instance, class_1309 livingEntity, Operation<Integer> original) {
        if (VanillaHudElements.isHidden(VanillaHudElements.FOOD_BAR_IDENTIFIER)) return 1000; //player food does not get rendered when
        return original.call(instance, livingEntity);
    }

    /**
     * @reason Revert patch to getVehicleMaxHearts() from method above.
     */
    @WrapOperation(method = "renderPlayerHealth", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;getVisibleVehicleHeartRows(I)I"))
    private int wrap_getVisibleVehicleHeartRows_in_renderPlayerHealth_Spiffy(class_329 instance, int $$0, Operation<Integer> original) {
        return original.call(instance, this.getVehicleMaxHearts(this.getPlayerVehicleWithHealth()));
    }

    /**
     * @reason Hide the player air bar when hidden by Spiffy HUD.
     */
    @WrapOperation(method = "renderPlayerHealth", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;getAirSupply()I"))
    private int wrap_getAirSupply_in_renderPlayerHealth_Spiffy(class_1657 instance, Operation<Integer> original) {
        if (VanillaHudElements.isHidden(VanillaHudElements.AIR_BAR_IDENTIFIER)) return 1000000000; //air bar is invisible when air is >= max air, so just set a very high air here to hide the bar
        return original.call(instance);
    }

    /**
     * @reason Hide the player air bar when hidden by Spiffy HUD.
     */
    @WrapOperation(method = "renderPlayerHealth", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;isEyeInFluid(Lnet/minecraft/tags/TagKey;)Z"))
    private boolean wrap_isEyeInFluid_in_renderPlayerHealth_Spiffy(class_1657 instance, class_6862<?> tagKey, Operation<Boolean> original) {
        if (VanillaHudElements.isHidden(VanillaHudElements.AIR_BAR_IDENTIFIER)) return false;
        return original.call(instance, tagKey);
    }

    /**
     * @reason Hide the player health bar when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "renderPlayerHealth", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderHearts(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;IIIIFIIIZ)V"))
    private boolean wrap_renderHearts_in_renderPlayerHealth_Spiffy(class_329 instance, class_332 $$0, class_1657 $$1, int $$2, int $$3, int $$4, int $$5, float $$6, int $$7, int $$8, int $$9, boolean $$10) {
        return !VanillaHudElements.isHidden(VanillaHudElements.PLAYER_HEALTH_BAR_IDENTIFIER);
    }

    /**
     * @reason Hide the effects overlay when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderEffects(Lnet/minecraft/client/gui/GuiGraphics;)V"))
    private boolean wrap_renderEffects_in_render_Spiffy(class_329 instance, class_332 $$0) {
        return !VanillaHudElements.isHidden(VanillaHudElements.EFFECTS_IDENTIFIER);
    }

    /**
     * @reason Hide the hotbar attack indicator when hidden by Spiffy HUD.
     */
    @WrapOperation(method = "renderHotbar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;getAttackStrengthScale(F)F"))
    private float wrap_getAttackStrengthScale_in_renderHotbar_Spiffy(class_746 instance, float v, Operation<Float> original) {
        if (VanillaHudElements.isHidden(VanillaHudElements.ATTACK_INDICATOR_IDENTIFIER)) return 1.0f; //indicator only gets rendered when attack strength is not at 100%
        return original.call(instance, v);
    }

    /**
     * @reason Hide the crosshair attack indicator when hidden by Spiffy HUD.
     */
    @WrapOperation(method = "renderCrosshair", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;getAttackStrengthScale(F)F"))
    private float wrap_getAttackStrengthScale_in_renderCrosshair_Spiffy(class_746 instance, float v, Operation<Float> original) {
        if (VanillaHudElements.isHidden(VanillaHudElements.ATTACK_INDICATOR_IDENTIFIER)) return 1.0f; //indicator only gets rendered when attack strength is not at 100%
        return original.call(instance, v);
    }

    /**
     * @reason Hide the vignette overlay when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderVignette(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/Entity;)V"))
    private boolean wrap_renderVignette_in_render_Spiffy(class_329 instance, class_332 $$0, class_1297 $$1) {
        return !OverlayRemoverElement.isOverlayTypeHidden(OverlayRemoverElement.OverlayType.VIGNETTE);
    }

    /**
     * @reason Hide the spyglass overlay when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderSpyglassOverlay(Lnet/minecraft/client/gui/GuiGraphics;F)V"))
    private boolean wrap_renderSpyglassOverlay_in_render_Spiffy(class_329 instance, class_332 $$0, float $$1) {
        return !OverlayRemoverElement.isOverlayTypeHidden(OverlayRemoverElement.OverlayType.SPYGLASS);
    }

    /**
     * @reason Hide the pumpkin overlay when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderTextureOverlay(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/resources/ResourceLocation;F)V"))
    private boolean wrap_pumpkin_overlay_rendering_in_render_Spiffy(class_329 instance, class_332 graphics, class_2960 location, float f) {
        if (location == PUMPKIN_BLUR_LOCATION) {
            return !OverlayRemoverElement.isOverlayTypeHidden(OverlayRemoverElement.OverlayType.PUMPKIN);
        }
        return true;
    }

    /**
     * @reason Hide the powder snow overlay when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderTextureOverlay(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/resources/ResourceLocation;F)V"))
    private boolean wrap_powder_snow_overlay_rendering_in_render_Spiffy(class_329 instance, class_332 graphics, class_2960 location, float f) {
        if (location == POWDER_SNOW_OUTLINE_LOCATION) {
            return !OverlayRemoverElement.isOverlayTypeHidden(OverlayRemoverElement.OverlayType.POWDER_SNOW);
        }
        return true;
    }

    /**
     * @reason Hide the portal overlay when hidden by Spiffy HUD.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Gui;renderPortalOverlay(Lnet/minecraft/client/gui/GuiGraphics;F)V"))
    private boolean wrap_renderPortalOverlay_in_render_Spiffy(class_329 instance, class_332 $$0, float $$1) {
        return !OverlayRemoverElement.isOverlayTypeHidden(OverlayRemoverElement.OverlayType.PORTAL);
    }

}
