package de.keksuccino.spiffyhud.util.player;

import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;

public class PlayerUtils {

    public static float getItemUseProgress(class_1657 player) {

        // If there's no player or the player isn’t using an item, return 0 progress.
        if (player == null || !player.method_6115()) {
            return 0.0F;
        }

        // Get the item stack that is currently being used.
        class_1799 stack = player.method_6030();
        if (stack.method_7960()) {
            return 0.0F;
        }

        // Get the total duration of the use action (e.g., eating, drawing a bow).
        int totalDuration = stack.method_7935();
        // Get how many ticks remain until the use is complete.
        int remainingTicks = player.method_6014();

        // Avoid division by zero (shouldn't happen if use duration is set properly).
        if (totalDuration <= 0) {
            return 0.0F;
        }

        // Compute linear progress: 0.0 when just started, 1.0 when finished.
        float progress = (totalDuration - remainingTicks) / (float) totalDuration;

        // For items like bows, vanilla applies a nonlinear scaling so that the pull feels right.
        if (stack.method_7909() instanceof class_1753) {
            progress = (progress * progress + progress * 2.0F) / 3.0F;
            if (progress > 1.0F) {
                progress = 1.0F;
            }
        }

        return progress;

    }

}
