package de.keksuccino.spiffyhud.util.rendering.exclusion;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_8030;

public class ExclusionAreaStack {

    private final Deque<class_8030> stack = new ArrayDeque<>();
    
    public void push(class_8030 area) {
        stack.addLast(area);
    }
    
    public void pop() {
        if (stack.isEmpty()) {
            throw new IllegalStateException("Exclusion area stack underflow");
        }
        stack.removeLast();
    }
    
    public boolean isEmpty() {
        return stack.isEmpty();
    }
    
    public void clear() {
        stack.clear();
    }
    
    public int size() {
        return stack.size();
    }
    
    public boolean isPointExcluded(float x, float y) {
        for (class_8030 area : stack) {
            if (containsPoint(area, (int)x, (int)y)) {
                return true;
            }
        }
        return false;
    }

    private static boolean containsPoint(class_8030 area, int i, int j) {
        return i >= area.method_49620() && i < area.method_49621() && j >= area.method_49618() && j < area.method_49619();
    }
    
    public boolean isRectangleFullyExcluded(float minX, float minY, float maxX, float maxY) {
        for (class_8030 area : stack) {
            if (area.method_49620() <= minX && area.method_49621() >= maxX && 
                area.method_49618() <= minY && area.method_49619() >= maxY) {
                return true;
            }
        }
        return false;
    }
    
    public boolean doesRectangleIntersectExclusion(float minX, float minY, float maxX, float maxY) {
        for (class_8030 area : stack) {
            if (!(maxX < area.method_49620() || minX > area.method_49621() || 
                  maxY < area.method_49618() || minY > area.method_49619())) {
                return true;
            }
        }
        return false;
    }
    
}
