/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.playerairbar;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.playerairbar.PlayerAirBubbleBarEditorElement;
import de.keksuccino.spiffyhud.customization.elements.playerairbar.PlayerAirBubbleBarElement;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerAirBubbleBarElementBuilder
extends ElementBuilder<PlayerAirBubbleBarElement, PlayerAirBubbleBarEditorElement> {
    public PlayerAirBubbleBarElementBuilder() {
        super("spiffy_player_air_bubble_bar");
    }

    @NotNull
    public PlayerAirBubbleBarElement buildDefaultInstance() {
        PlayerAirBubbleBarElement element = new PlayerAirBubbleBarElement(this);
        element.baseWidth = 100;
        element.baseHeight = 100;
        return element;
    }

    public PlayerAirBubbleBarElement deserializeElement(@NotNull SerializedElement serialized) {
        SpiffyAlignment parsed;
        PlayerAirBubbleBarElement element = this.buildDefaultInstance();
        element.bubblesPerRow = Math.max(1, (Integer)this.deserializeNumber(Integer.class, element.bubblesPerRow, serialized.getValue("bubbles_per_row")));
        element.bubbleGap = Math.max(0, (Integer)this.deserializeNumber(Integer.class, element.bubbleGap, serialized.getValue("bubble_gap")));
        element.scaleMultiplier = Objects.requireNonNullElse(serialized.getValue("scale_multiplier"), element.scaleMultiplier);
        element.blinkOnLoss = this.deserializeBoolean(element.blinkOnLoss, serialized.getValue("blink_on_loss"));
        element.lowAirShakeEnabled = this.deserializeBoolean(element.lowAirShakeEnabled, serialized.getValue("shake_enabled"));
        element.lowAirShakeThresholdBubbles = Math.max(0, (Integer)this.deserializeNumber(Integer.class, element.lowAirShakeThresholdBubbles, serialized.getValue("shake_threshold_bubbles")));
        element.poppingDurationMs = Math.max(0, (Integer)this.deserializeNumber(Integer.class, element.poppingDurationMs, serialized.getValue("pop_duration_ms")));
        String alignment = serialized.getValue("spiffy_alignment");
        if (alignment != null && (parsed = SpiffyAlignment.getByName(alignment)) != null) {
            element.spiffyAlignment = parsed;
        }
        for (PlayerAirBubbleBarElement.AirTextureKind kind : PlayerAirBubbleBarElement.AirTextureKind.values()) {
            String key = PlayerAirBubbleBarElementBuilder.texturePropertyKey(kind);
            ResourceSupplier supplier = PlayerAirBubbleBarElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue(key));
            element.setCustomTexture(kind, (ResourceSupplier<ITexture>)supplier);
        }
        return element;
    }

    @Nullable
    public PlayerAirBubbleBarElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        PlayerAirBubbleBarElement element = (PlayerAirBubbleBarElement)super.deserializeElementInternal(serialized);
        if (element != null) {
            element.stayOnScreen = this.deserializeBoolean(element.stayOnScreen, serialized.getValue("stay_on_screen"));
        }
        return element;
    }

    protected SerializedElement serializeElement(@NotNull PlayerAirBubbleBarElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("bubbles_per_row", "" + element.bubblesPerRow);
        serializeTo.putProperty("bubble_gap", "" + element.bubbleGap);
        serializeTo.putProperty("scale_multiplier", element.scaleMultiplier);
        serializeTo.putProperty("blink_on_loss", "" + element.blinkOnLoss);
        serializeTo.putProperty("shake_enabled", "" + element.lowAirShakeEnabled);
        serializeTo.putProperty("shake_threshold_bubbles", "" + element.lowAirShakeThresholdBubbles);
        serializeTo.putProperty("pop_duration_ms", "" + element.poppingDurationMs);
        serializeTo.putProperty("spiffy_alignment", element.spiffyAlignment.getName());
        for (PlayerAirBubbleBarElement.AirTextureKind kind : PlayerAirBubbleBarElement.AirTextureKind.values()) {
            ResourceSupplier<ITexture> supplier = element.getCustomTexture(kind);
            if (supplier == null) continue;
            serializeTo.putProperty(PlayerAirBubbleBarElementBuilder.texturePropertyKey(kind), supplier.getSourceWithPrefix());
        }
        return serializeTo;
    }

    private static String texturePropertyKey(@NotNull PlayerAirBubbleBarElement.AirTextureKind kind) {
        return "texture_" + kind.name().toLowerCase(Locale.ROOT);
    }

    @NotNull
    public PlayerAirBubbleBarEditorElement wrapIntoEditorElement(@NotNull PlayerAirBubbleBarElement element, @NotNull LayoutEditorScreen editor) {
        return new PlayerAirBubbleBarEditorElement(element, editor);
    }

    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        return class_2561.method_43471((String)"spiffyhud.elements.player_air_bubble_bar");
    }

    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.elements.player_air_bubble_bar.desc", (String[])new String[0]);
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }
}

