/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.singlelinetext;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.singlelinetext.SingleLineTextEditorElement;
import de.keksuccino.spiffyhud.customization.elements.singlelinetext.SingleLineTextElement;
import java.util.Objects;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleLineTextElementBuilder
extends ElementBuilder<SingleLineTextElement, SingleLineTextEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SingleLineTextElementBuilder() {
        super("spiffy_single_line_text");
    }

    @NotNull
    public SingleLineTextElement buildDefaultInstance() {
        SingleLineTextElement i = new SingleLineTextElement(this);
        i.baseWidth = 100;
        i.baseHeight = 100;
        i.stickyAnchor = true;
        i.stayOnScreen = false;
        return i;
    }

    public SingleLineTextElement deserializeElement(@NotNull SerializedElement serialized) {
        SingleLineTextElement element = this.buildDefaultInstance();
        element.text = serialized.getValue("text");
        element.textScale = Objects.requireNonNullElse(serialized.getValue("text_scale"), element.textScale);
        return element;
    }

    @Nullable
    public SingleLineTextElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        SingleLineTextElement e = (SingleLineTextElement)super.deserializeElementInternal(serialized);
        if (e != null) {
            e.stayOnScreen = this.deserializeBoolean(e.stayOnScreen, serialized.getValue("stay_on_screen"));
        }
        return e;
    }

    protected SerializedElement serializeElement(@NotNull SingleLineTextElement element, @NotNull SerializedElement serializeTo) {
        if (element.text != null) {
            serializeTo.putProperty("text", element.text);
        }
        serializeTo.putProperty("text_scale", element.textScale);
        return serializeTo;
    }

    @NotNull
    public SingleLineTextEditorElement wrapIntoEditorElement(@NotNull SingleLineTextElement element, @NotNull LayoutEditorScreen editor) {
        return new SingleLineTextEditorElement(element, editor);
    }

    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        return class_2561.method_43471((String)"spiffyhud.elements.single_line_text");
    }

    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.elements.single_line_text.desc", (String[])new String[0]);
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }
}

