/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SizeAndPositionRecorder;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4074;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_485;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeEffectsElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_310 minecraft = class_310.method_1551();
    protected int tickCount;
    private int barHeight = 60;
    private int barWidth = 100;
    private boolean shouldRenderBar = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikeEffectsElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.field_1724 == null) {
            return;
        }
        if (this.minecraft.field_1687 == null) {
            return;
        }
        this.shouldRenderBar = false;
        this.renderEffects(graphics, 0, 0);
        int elementAbsX = this.getAbsoluteX();
        int elementAbsY = this.getAbsoluteY();
        int elementHeight = this.getAbsoluteHeight();
        int baseY = elementAbsY;
        if (this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT) {
            baseY += (elementHeight - this.barHeight) / 2;
        } else if (this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT) {
            baseY += elementHeight - this.barHeight;
        }
        int baseX = elementAbsX;
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((class_332)graphics);
        this.shouldRenderBar = true;
        this.renderEffects(graphics, baseX, baseY);
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    protected void renderEffects(class_332 graphics, int baseX, int baseY) {
        float iconTransparency;
        int iconY;
        int iconX;
        class_1058 effectSprite;
        int fadeFactor;
        float iconAlpha;
        int finalIconX;
        int relativeX;
        class_1293 effectInstance;
        int i;
        int requiredWidth;
        class_437 currentScreen;
        List<class_1293> activeEffects = Objects.requireNonNull(this.minecraft.field_1724).method_6026();
        if (VanillaLikeEffectsElement.isEditor()) {
            activeEffects = List.of(new class_1293(class_1294.field_5926, 300), new class_1293(class_1294.field_5918, 300), new class_1293(class_1294.field_16595, 300));
        }
        if (activeEffects.isEmpty() || (currentScreen = this.minecraft.field_1755) instanceof class_485 && ((class_485)currentScreen).method_38934()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
        ArrayList<class_1293> beneficialEffects = new ArrayList<class_1293>();
        ArrayList<class_1293> harmfulEffects = new ArrayList<class_1293>();
        for (class_1293 effectInstance2 : Ordering.natural().reverse().sortedCopy(activeEffects)) {
            if (!effectInstance2.method_5592()) continue;
            if (effectInstance2.method_5579().method_5573()) {
                beneficialEffects.add(effectInstance2);
                continue;
            }
            harmfulEffects.add(effectInstance2);
        }
        ArrayList renderTasks = Lists.newArrayListWithExpectedSize((int)activeEffects.size());
        SizeAndPositionRecorder recorder = new SizeAndPositionRecorder();
        recorder.setWidthOffset(24);
        recorder.setHeightOffset(24);
        boolean isLeftAligned = this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT;
        boolean isRightAligned = this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT;
        int baseRowOffset = 1;
        if (this.minecraft.method_1530()) {
            baseRowOffset += 15;
        }
        int beneficialRowY = baseY + baseRowOffset;
        int harmfulRowY = baseY + baseRowOffset + 26;
        int beneficialIconCount = beneficialEffects.size();
        int harmfulIconCount = harmfulEffects.size();
        int elementWidth = requiredWidth = Math.max(beneficialIconCount, harmfulIconCount) * 25;
        int beneficialStartX = isLeftAligned ? 0 : (isRightAligned ? elementWidth - beneficialIconCount * 25 : (elementWidth - beneficialIconCount * 25) / 2);
        int harmfulStartX = isLeftAligned ? 0 : (isRightAligned ? elementWidth - harmfulIconCount * 25 : (elementWidth - harmfulIconCount * 25) / 2);
        class_4074 effectTextureManager = this.minecraft.method_18505();
        for (i = 0; i < beneficialIconCount; ++i) {
            effectInstance = (class_1293)beneficialEffects.get(i);
            relativeX = beneficialStartX + 25 * i;
            finalIconX = baseX + relativeX;
            iconAlpha = 1.0f;
            if (this.shouldRenderBar) {
                if (effectInstance.method_5591()) {
                    graphics.method_25302(class_465.field_2801, finalIconX, beneficialRowY, 165, 166, 24, 24);
                } else {
                    graphics.method_25302(class_465.field_2801, finalIconX, beneficialRowY, 141, 166, 24, 24);
                    if (effectInstance.method_48557(200)) {
                        int duration = effectInstance.method_5584();
                        fadeFactor = 10 - duration / 20;
                        iconAlpha = class_3532.method_15363((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + class_3532.method_15362((float)((float)duration * (float)Math.PI / 5.0f)) * class_3532.method_15363((float)((float)fadeFactor / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                    }
                }
            }
            effectSprite = effectTextureManager.method_18663(effectInstance.method_5579());
            recorder.updateX(finalIconX);
            recorder.updateY(beneficialRowY);
            iconX = finalIconX;
            iconY = beneficialRowY;
            float f = iconTransparency = iconAlpha > this.opacity ? this.opacity : iconAlpha;
            if (!this.shouldRenderBar) continue;
            renderTasks.add(() -> {
                graphics.method_51422(1.0f, 1.0f, 1.0f, iconTransparency);
                graphics.method_25298(iconX + 3, iconY + 3, 0, 18, 18, effectSprite);
                graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            });
        }
        for (i = 0; i < harmfulIconCount; ++i) {
            effectInstance = (class_1293)harmfulEffects.get(i);
            relativeX = harmfulStartX + 25 * i;
            finalIconX = baseX + relativeX;
            iconAlpha = 1.0f;
            if (this.shouldRenderBar) {
                if (effectInstance.method_5591()) {
                    graphics.method_25302(class_465.field_2801, finalIconX, harmfulRowY, 165, 166, 24, 24);
                } else {
                    graphics.method_25302(class_465.field_2801, finalIconX, harmfulRowY, 141, 166, 24, 24);
                    if (effectInstance.method_48557(200)) {
                        int duration = effectInstance.method_5584();
                        fadeFactor = 10 - duration / 20;
                        iconAlpha = class_3532.method_15363((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + class_3532.method_15362((float)((float)duration * (float)Math.PI / 5.0f)) * class_3532.method_15363((float)((float)fadeFactor / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                    }
                }
            }
            effectSprite = effectTextureManager.method_18663(effectInstance.method_5579());
            recorder.updateX(finalIconX);
            recorder.updateY(harmfulRowY);
            iconX = finalIconX;
            iconY = harmfulRowY;
            float f = iconTransparency = iconAlpha > this.opacity ? this.opacity : iconAlpha;
            if (!this.shouldRenderBar) continue;
            renderTasks.add(() -> {
                graphics.method_51422(1.0f, 1.0f, 1.0f, iconTransparency);
                graphics.method_25298(iconX + 3, iconY + 3, 0, 18, 18, effectSprite);
                graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            });
        }
        this.barHeight = recorder.getHeight();
        this.barWidth = requiredWidth;
        renderTasks.forEach(Runnable::run);
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }
}

