/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FlatMobRenderUtils {
    private static final class_310 MC = class_310.method_1551();
    private static final float VIEWPORT_FILL_RATIO = 0.92f;
    private static final float HALF = 0.5f;
    private static final Map<class_1308, class_1308> RENDER_CLONES = new WeakHashMap<class_1308, class_1308>();

    private FlatMobRenderUtils() {
    }

    public static boolean renderFlatMob(@NotNull class_332 graphics, int left, int top, int size, @Nullable class_1308 mob, float opacity) {
        class_1308 renderMob = FlatMobRenderUtils.prepareRenderMob(mob);
        if (renderMob == null) {
            return false;
        }
        graphics.method_44379(left, top, left + size, top + size);
        float centerX = (float)left + (float)size / 2.0f;
        float centerY = (float)top + (float)size / 2.0f;
        MobBounds bounds = FlatMobRenderUtils.captureBounds(renderMob);
        float scale = FlatMobRenderUtils.computeScale(bounds, size);
        Vector3f offset = new Vector3f(0.0f, bounds.height * 0.5f, 0.0f);
        Quaternionf baseRotation = class_7833.field_40718.rotationDegrees(180.0f);
        float originalBody = renderMob.field_6283;
        float originalBodyO = renderMob.field_6220;
        float originalYRot = renderMob.method_36454();
        float originalYRotO = renderMob.field_5982;
        float originalXRot = renderMob.method_36455();
        float originalXRotO = renderMob.field_6004;
        float originalHead = renderMob.field_6241;
        float originalHeadO = renderMob.field_6259;
        renderMob.method_5636(180.0f);
        renderMob.field_6220 = 180.0f;
        renderMob.method_36456(180.0f);
        renderMob.field_5982 = 180.0f;
        renderMob.method_36457(0.0f);
        renderMob.field_6004 = 0.0f;
        renderMob.method_5847(180.0f);
        renderMob.field_6259 = 180.0f;
        RenderSystem.enableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, opacity);
        graphics.method_51448().method_22903();
        FlatMobRenderUtils.renderEntity(graphics, centerX, centerY, scale, offset, baseRotation, renderMob);
        graphics.method_51448().method_22909();
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        class_308.method_24211();
        renderMob.method_5636(originalBody);
        renderMob.field_6220 = originalBodyO;
        renderMob.method_36456(originalYRot);
        renderMob.field_5982 = originalYRotO;
        renderMob.method_36457(originalXRot);
        renderMob.field_6004 = originalXRotO;
        renderMob.method_5847(originalHead);
        renderMob.field_6259 = originalHeadO;
        graphics.method_44380();
        return true;
    }

    private static void renderEntity(@NotNull class_332 graphics, float centerX, float centerY, float scale, @NotNull Vector3f offset, @NotNull Quaternionf modelRotation, @NotNull class_1308 mob) {
        graphics.method_51448().method_22904((double)centerX, (double)centerY, 50.0);
        graphics.method_51448().method_22905(scale, scale, -scale);
        graphics.method_51448().method_46416(offset.x, offset.y, offset.z);
        graphics.method_51448().method_22907(modelRotation);
        class_308.method_34742();
        class_898 dispatcher = class_310.method_1551().method_1561();
        class_765 lightTexture = class_310.method_1551().field_1773.method_22974();
        int previousLightTexture = RenderSystem.getShaderTexture((int)2);
        lightTexture.method_3316();
        Vector3f frontLight = new Vector3f(0.0f, 0.0f, 1.0f).normalize();
        RenderSystem.setShaderLights((Vector3f)frontLight, (Vector3f)frontLight);
        dispatcher.method_3948(false);
        RenderSystem.runAsFancy(() -> dispatcher.method_3954((class_1297)mob, 0.0, 0.0, 0.0, 0.0f, 1.0f, graphics.method_51448(), (class_4597)graphics.method_51450(), 0xF000F0));
        graphics.method_51452();
        dispatcher.method_3948(true);
        if (previousLightTexture == 0) {
            lightTexture.method_3315();
        } else {
            RenderSystem.setShaderTexture((int)2, (int)previousLightTexture);
        }
        class_308.method_24211();
    }

    @NotNull
    private static MobBounds captureBounds(@NotNull class_1308 mob) {
        class_238 boundingBox = mob.method_5829();
        double width = boundingBox.field_1320 - boundingBox.field_1323;
        double height = boundingBox.field_1325 - boundingBox.field_1322;
        double depth = boundingBox.field_1324 - boundingBox.field_1321;
        float widthF = (float)Math.max(width, (double)0.001f);
        float heightF = (float)Math.max(height, (double)0.001f);
        float depthF = (float)Math.max(depth, (double)0.001f);
        return new MobBounds(heightF, Math.max(widthF, depthF));
    }

    private static float computeScale(@NotNull MobBounds bounds, int size) {
        float dominant = Math.max(bounds.height, bounds.horizontal);
        float available = Math.max((float)size * 0.92f, 1.0f);
        return available / dominant;
    }

    @Nullable
    private static class_1308 prepareRenderMob(@Nullable class_1308 source) {
        if (!FlatMobRenderUtils.isRenderableSource(source)) {
            FlatMobRenderUtils.evict(source);
            return null;
        }
        class_1937 level = source.method_37908();
        if (level == null) {
            FlatMobRenderUtils.evict(source);
            return null;
        }
        class_1308 clone = RENDER_CLONES.get(source);
        if (clone == null || clone.method_31481() || clone.method_37908() != level) {
            clone = FlatMobRenderUtils.createClone(source);
            if (clone == null) {
                FlatMobRenderUtils.evict(source);
                return null;
            }
            RENDER_CLONES.put(source, clone);
        }
        return clone;
    }

    private static boolean isRenderableSource(@Nullable class_1308 source) {
        return source != null && source.method_5805() && !source.method_31481();
    }

    private static void evict(@Nullable class_1308 source) {
        if (source != null) {
            RENDER_CLONES.remove(source);
        }
    }

    @Nullable
    private static class_1308 createClone(@NotNull class_1308 source) {
        class_1937 level = source.method_37908();
        if (level == null) {
            level = FlatMobRenderUtils.MC.field_1687;
        }
        if (level == null) {
            return null;
        }
        class_1297 created = source.method_5864().method_5883(level);
        if (!(created instanceof class_1308)) {
            return null;
        }
        class_1308 copy = (class_1308)created;
        copy.method_5875(true);
        copy.method_5977(true);
        copy.field_5960 = true;
        copy.method_5803(true);
        FlatMobRenderUtils.copyMobData(source, copy);
        return copy;
    }

    private static void copyMobData(@NotNull class_1308 source, @NotNull class_1308 target) {
        class_2487 tag = new class_2487();
        source.method_5647(tag);
        tag.method_10556("PersistenceRequired", false);
        target.method_5651(tag);
        target.method_5875(true);
        target.method_5977(true);
        target.field_5960 = true;
        target.method_5803(true);
    }

    private static final class MobBounds {
        private final float height;
        private final float horizontal;

        private MobBounds(float height, float horizontal) {
            this.height = height;
            this.horizontal = horizontal;
        }
    }
}

