/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.rendering.exclusion;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_8030;

public class ExclusionAreaStack {
    private final Deque<class_8030> stack = new ArrayDeque<class_8030>();

    public void push(class_8030 area) {
        this.stack.addLast(area);
    }

    public void pop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Exclusion area stack underflow");
        }
        this.stack.removeLast();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void clear() {
        this.stack.clear();
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isPointExcluded(float x, float y) {
        for (class_8030 area : this.stack) {
            if (!ExclusionAreaStack.containsPoint(area, (int)x, (int)y)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsPoint(class_8030 area, int i, int j) {
        return i >= area.method_49620() && i < area.method_49621() && j >= area.method_49618() && j < area.method_49619();
    }

    public boolean isRectangleFullyExcluded(float minX, float minY, float maxX, float maxY) {
        for (class_8030 area : this.stack) {
            if (!((float)area.method_49620() <= minX) || !((float)area.method_49621() >= maxX) || !((float)area.method_49618() <= minY) || !((float)area.method_49619() >= maxY)) continue;
            return true;
        }
        return false;
    }

    public boolean doesRectangleIntersectExclusion(float minX, float minY, float maxX, float maxY) {
        for (class_8030 area : this.stack) {
            if (maxX < (float)area.method_49620() || minX > (float)area.method_49621() || maxY < (float)area.method_49618() || minY > (float)area.method_49619()) continue;
            return true;
        }
        return false;
    }
}

