/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.chatcustomizer;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.chatcustomizer.ChatCustomizerEditorElement;
import de.keksuccino.spiffyhud.customization.elements.chatcustomizer.ChatCustomizerElement;
import de.keksuccino.spiffyhud.customization.elements.chatcustomizer.ChatCustomizerHandler;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatCustomizerElementBuilder
extends ElementBuilder<ChatCustomizerElement, ChatCustomizerEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ChatCustomizerElementBuilder() {
        super("spiffy_chat_customizer");
    }

    @NotNull
    public ChatCustomizerElement buildDefaultInstance() {
        ChatCustomizerElement i = new ChatCustomizerElement(this);
        i.baseWidth = 100;
        i.baseHeight = 100;
        i.inEditorColor = DrawableColor.of((Color)new Color(50, 168, 146));
        return i;
    }

    public ChatCustomizerElement deserializeElement(@NotNull SerializedElement serialized) {
        ChatCustomizerElement element = this.buildDefaultInstance();
        element.chatCorner = Objects.requireNonNullElse(ChatCustomizerHandler.ChatCorner.getByName(Objects.requireNonNullElse(serialized.getValue("chat_corner"), ChatCustomizerHandler.ChatCorner.BOTTOM_LEFT.getName())), element.chatCorner);
        element.customChatBackgroundColor = serialized.getValue("custom_chat_background_color");
        element.customInputBackgroundColor = serialized.getValue("custom_input_background_color");
        element.customLineSpacing = serialized.getValue("custom_line_spacing");
        return element;
    }

    protected SerializedElement serializeElement(@NotNull ChatCustomizerElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("chat_corner", element.chatCorner.getName());
        if (element.customChatBackgroundColor != null) {
            serializeTo.putProperty("custom_chat_background_color", element.customChatBackgroundColor);
        }
        if (element.customInputBackgroundColor != null) {
            serializeTo.putProperty("custom_input_background_color", element.customInputBackgroundColor);
        }
        if (element.customLineSpacing != null) {
            serializeTo.putProperty("custom_line_spacing", element.customLineSpacing);
        }
        return serializeTo;
    }

    @NotNull
    public ChatCustomizerEditorElement wrapIntoEditorElement(@NotNull ChatCustomizerElement element, @NotNull LayoutEditorScreen editor) {
        return new ChatCustomizerEditorElement(element, editor);
    }

    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.m_237115_((String)"spiffyhud.elements.chat_customizer");
    }

    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.elements.chat_customizer.desc", (String[])new String[0]);
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }
}

