/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.overlayremover;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.util.Pair;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayRemoverElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    public OverlayType overlayType = OverlayType.VIGNETTE;
    protected static final Map<OverlayType, Pair<Long, Boolean>> CACHED_OVERLAY_VISIBILITY = new HashMap<OverlayType, Pair<Long, Boolean>>();

    public OverlayRemoverElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (OverlayRemoverElement.isEditor()) {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            RenderSystem.enableBlend();
            graphics.m_280509_(x, y, x + w, y + h, this.inEditorColor.getColorInt());
            graphics.m_280588_(x, y, x + w, y + h);
            Font font = Minecraft.m_91087_().f_91062_;
            Component component = this.getDisplayName();
            int n = x + w / 2;
            int n2 = y + h / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            graphics.m_280653_(font, component, n, n2 - 9 / 2, -1);
            graphics.m_280618_();
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        }
    }

    public static boolean isOverlayTypeHidden(@NotNull OverlayType type) {
        long now = System.currentTimeMillis();
        Pair<Long, Boolean> cached = CACHED_OVERLAY_VISIBILITY.get((Object)type);
        if (cached != null && (Long)cached.getKey() + 100L > now) {
            return (Boolean)cached.getValue();
        }
        boolean returnVal = false;
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(SpiffyOverlayScreen.class);
        if (layer != null) {
            for (AbstractElement element : layer.allElements) {
                OverlayRemoverElement e;
                if (!(element instanceof OverlayRemoverElement) || !(e = (OverlayRemoverElement)element).shouldRender()) continue;
                if (e.overlayType == OverlayType.ALL) {
                    returnVal = true;
                }
                if (e.overlayType == type) {
                    returnVal = true;
                }
                if (!returnVal) continue;
                break;
            }
        }
        CACHED_OVERLAY_VISIBILITY.put(type, (Pair<Long, Boolean>)Pair.of((Object)now, (Object)returnVal));
        return returnVal;
    }

    public static enum OverlayType implements LocalizedCycleEnum<OverlayType>
    {
        POWDER_SNOW("powder_snow"),
        PUMPKIN("pumpkin"),
        VIGNETTE("vignette"),
        SPYGLASS("spyglass"),
        PORTAL("portal"),
        ALL("all");

        public final String name;

        private OverlayType(String name) {
            this.name = name;
        }

        @NotNull
        public String getLocalizationKeyBase() {
            return "spiffyhud.elements.overlay_remover.overlay_type";
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Style getValueComponentStyle() {
            return (Style)WARNING_TEXT_STYLE.get();
        }

        @NotNull
        public OverlayType[] getValues() {
            return OverlayType.values();
        }

        @Nullable
        public OverlayType getByNameInternal(@NotNull String s) {
            return OverlayType.getByName(s);
        }

        @Nullable
        public static OverlayType getByName(@NotNull String name) {
            for (OverlayType type : OverlayType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

