/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.jumpmeter;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PlayerRideableJumping;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeJumpMeterElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 5;
    private final Minecraft minecraft = Minecraft.m_91087_();

    public VanillaLikeJumpMeterElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.f_91074_ == null || this.minecraft.f_91073_ == null) {
            return;
        }
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        this.renderJumpMeter(graphics, elementX, elementY, elementWidth, elementHeight);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderJumpMeter(GuiGraphics graphics, int elementX, int elementY, int elementWidth, int elementHeight) {
        RenderSystem.enableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, this.opacity);
        PlayerRideableJumping rideable = Objects.requireNonNull(this.minecraft.f_91074_).m_245714_();
        float jumpScale = this.minecraft.f_91074_.m_108634_();
        int fillWidth = (int)(jumpScale * (float)elementWidth);
        if (VanillaLikeJumpMeterElement.isEditor()) {
            fillWidth = 91;
        }
        graphics.m_280218_(GUI_ICONS_LOCATION, elementX, elementY, 0, 84, elementWidth, elementHeight);
        if (rideable != null && rideable.m_245614_() > 0 && !VanillaLikeJumpMeterElement.isEditor()) {
            graphics.m_280218_(GUI_ICONS_LOCATION, elementX, elementY, 0, 74, elementWidth, elementHeight);
        } else if (fillWidth > 0) {
            graphics.m_280218_(GUI_ICONS_LOCATION, elementX, elementY, 0, 89, fillWidth, elementHeight);
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public int getAbsoluteWidth() {
        return 182;
    }

    public int getAbsoluteHeight() {
        return 5;
    }
}

