/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.networking.packets.structure.playerpos;

import de.keksuccino.fancymenu.networking.Packet;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.spiffyhud.networking.packets.structure.playerpos.PlayerPosStructuresPacket;
import de.keksuccino.spiffyhud.util.level.StructureUtils;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlayerPosStructuresPacketLogic {
    private static final Logger LOGGER = LogManager.getLogger();

    protected static boolean handleOnServer(@NotNull PlayerPosStructuresPacket packet, @NotNull ServerPlayer sender) {
        Level level = sender.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            PlayerPosStructuresPacket answer = new PlayerPosStructuresPacket();
            answer.structures = StructureUtils.convertStructureKeysToStrings(StructureUtils.getAllStructuresAt(level2, sender.m_20183_()));
            PacketHandler.sendToClient((ServerPlayer)sender, (Packet)answer);
            return true;
        }
        return false;
    }

    protected static boolean handleOnClient(@NotNull PlayerPosStructuresPacket packet) {
        MainThreadTaskExecutor.executeInMainThread(() -> {
            PlayerPosStructuresPacket.CACHED_CURRENT_STRUCTURES.clear();
            PlayerPosStructuresPacket.CACHED_CURRENT_STRUCTURES.addAll(Objects.requireNonNullElse(packet.structures, new ArrayList()));
        }, (MainThreadTaskExecutor.ExecuteTiming)MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
        return true;
    }
}

