/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.level;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public class StructureUtils {
    public static boolean isInStructure(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull ResourceKey<Structure> structure) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        List<ResourceKey<Structure>> structures = StructureUtils.getAllStructuresAt(level, pos);
        for (ResourceKey<Structure> key : structures) {
            if (!key.toString().equals(structure.toString())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<ResourceKey<Structure>> getAllStructuresAt(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return List.of();
        }
        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
        ArrayList<ResourceKey<Structure>> keys = new ArrayList<ResourceKey<Structure>>();
        level.m_215010_().m_220522_(pos).forEach((structure, longs) -> {
            Optional structureKey = structureRegistry.m_7854_(structure);
            structureKey.ifPresent(keys::add);
        });
        return keys;
    }

    @NotNull
    public static ResourceKey<Structure> getStructureKey(@NotNull String structureId) {
        ResourceLocation resourceLocation = new ResourceLocation(structureId);
        return StructureUtils.getStructureKey(resourceLocation);
    }

    @NotNull
    public static ResourceKey<Structure> getStructureKey(@NotNull ResourceLocation location) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)location);
    }

    @NotNull
    public static List<ResourceKey<Structure>> getAllStructureKeys(@NotNull RegistryAccess registryAccess) {
        Registry structureRegistry = registryAccess.m_175515_(Registries.f_256944_);
        return new ArrayList<ResourceKey<Structure>>(structureRegistry.m_214010_());
    }

    @NotNull
    public static Optional<ResourceKey<Structure>> findStructureKey(@NotNull RegistryAccess registryAccess, @NotNull String structureName) {
        try {
            ResourceLocation resourceLocation = new ResourceLocation(structureName);
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)resourceLocation);
            Registry structureRegistry = registryAccess.m_175515_(Registries.f_256944_);
            if (structureRegistry.m_142003_(key)) {
                return Optional.of(key);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @NotNull
    public static List<String> convertStructureKeysToStrings(@NotNull List<ResourceKey<Structure>> keys) {
        ArrayList<String> stringKeys = new ArrayList<String>();
        keys.forEach(structureResourceKey -> stringKeys.add(structureResourceKey.m_135782_().toString()));
        return stringKeys;
    }
}

