/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.rendering.exclusion;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.gui.navigation.ScreenRectangle;

public class ExclusionAreaStack {
    private final Deque<ScreenRectangle> stack = new ArrayDeque<ScreenRectangle>();

    public void push(ScreenRectangle area) {
        this.stack.addLast(area);
    }

    public void pop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Exclusion area stack underflow");
        }
        this.stack.removeLast();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void clear() {
        this.stack.clear();
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isPointExcluded(float x, float y) {
        for (ScreenRectangle area : this.stack) {
            if (!ExclusionAreaStack.containsPoint(area, (int)x, (int)y)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsPoint(ScreenRectangle area, int i, int j) {
        return i >= area.m_274563_() && i < area.m_274445_() && j >= area.m_274449_() && j < area.m_274349_();
    }

    public boolean isRectangleFullyExcluded(float minX, float minY, float maxX, float maxY) {
        for (ScreenRectangle area : this.stack) {
            if (!((float)area.m_274563_() <= minX) || !((float)area.m_274445_() >= maxX) || !((float)area.m_274449_() <= minY) || !((float)area.m_274349_() >= maxY)) continue;
            return true;
        }
        return false;
    }

    public boolean doesRectangleIntersectExclusion(float minX, float minY, float maxX, float maxY) {
        for (ScreenRectangle area : this.stack) {
            if (maxX < (float)area.m_274563_() || minX > (float)area.m_274445_() || maxY < (float)area.m_274449_() || minY > (float)area.m_274349_()) continue;
            return true;
        }
        return false;
    }
}

